/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Random;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.hamcrest.Descriptors;
import org.apache.logging.log4j.hamcrest.FileMatchers;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class RollingAppenderTimeAndSizeTest {
    private static final String CONFIG = "log4j-rolling3.xml";
    private static final String DIR = "target/rolling3/test";
    public static LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("log4j-rolling3.xml");
    @Rule
    public RuleChain chain = loggerContextRule.withCleanFoldersRule("target/rolling3/test");
    private Logger logger;

    @Before
    public void setUp() throws Exception {
        this.logger = loggerContextRule.getLogger(RollingAppenderTimeAndSizeTest.class.getName());
    }

    @Test
    public void testAppender() throws Exception {
        Random rand = new Random();
        File logFile = new File("target/rolling3/rollingtest.log");
        Assert.assertTrue((String)"target/rolling3/rollingtest.log does not exist", (boolean)logFile.exists());
        FileTime time = (FileTime)Files.getAttribute(logFile.toPath(), "creationTime", new LinkOption[0]);
        for (int j = 0; j < 100; ++j) {
            int count = rand.nextInt(50);
            for (int i = 0; i < count; ++i) {
                this.logger.debug("This is test message number " + i);
            }
            Thread.sleep(rand.nextInt(50));
        }
        Thread.sleep(50L);
        File dir = new File(DIR);
        Assert.assertTrue((String)"Directory not created", (dir.exists() && dir.listFiles().length > 0 ? 1 : 0) != 0);
        Object[] files = dir.listFiles();
        Arrays.sort(files);
        Assert.assertNotNull((Object)files);
        Assert.assertThat((Object)files, (Matcher)Matchers.hasItemInArray(Descriptors.that(FileMatchers.hasName(Descriptors.that(Matchers.endsWith((String)".log"))))));
        boolean found = false;
        int fileCounter = 0;
        String previous = "";
        for (Object file : files) {
            String actual = ((File)file).getName();
            StringBuilder padding = new StringBuilder();
            String length = Long.toString(((File)file).length());
            for (int i = length.length(); i < 10; ++i) {
                padding.append(" ");
            }
            String[] fileParts = actual.split("_|\\.");
            fileCounter = previous.equals(fileParts[1]) ? ++fileCounter : 1;
            previous = fileParts[1];
            Assert.assertEquals((String)("Incorrect file name. Expected counter value of " + fileCounter + " in " + actual), (Object)Integer.toString(fileCounter), (Object)fileParts[2]);
        }
        FileTime endTime = (FileTime)Files.getAttribute(logFile.toPath(), "creationTime", new LinkOption[0]);
        Assert.assertNotEquals((String)"Creation times are equal", (Object)time, (Object)endTime);
    }
}

