/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverListener;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.rules.RuleChain;

public class RollingAppenderDirectCustomDeleteActionTest
implements RolloverListener {
    private static final String CONFIG = "log4j-rolling-direct-with-custom-delete.xml";
    private static final String DIR = "target/rolling-direct-with-delete/test";
    private final LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("log4j-rolling-direct-with-custom-delete.xml");
    @Rule
    public RuleChain chain = this.loggerContextRule.withCleanFoldersRule("target/rolling-direct-with-delete/test");
    private boolean fileFound = false;

    @Test
    public void testAppender() throws Exception {
        Logger logger = this.loggerContextRule.getLogger();
        RollingFileAppender app = (RollingFileAppender)this.loggerContextRule.getAppender("RollingFile");
        Assertions.assertNotNull((Object)app, (String)"No RollingFileAppender");
        ((RollingFileManager)app.getManager()).addRolloverListener((RolloverListener)this);
        for (int i = 0; i < 10; ++i) {
            logger.debug("This is a test message number " + i);
        }
        Thread.sleep(100L);
        File dir = new File(DIR);
        Assert.assertTrue((String)"Dir target/rolling-direct-with-delete/test should exist", (boolean)dir.exists());
        Assert.assertTrue((String)"Dir target/rolling-direct-with-delete/test should contain files", (dir.listFiles().length > 0 ? 1 : 0) != 0);
        File[] files = dir.listFiles();
        Assertions.assertNotNull((Object)files, (String)"No fiels");
        System.out.println(files[0].getName());
        long count = Arrays.stream(files).filter(f -> f.getName().endsWith("test-4.log")).count();
        Assert.assertTrue((String)"Deleted file was not created", (boolean)this.fileFound);
        Assert.assertEquals((String)("File count expected: 0, actual: " + count), (long)0L, (long)count);
    }

    public static void main(String[] args) {
        Pattern p = Pattern.compile("test-.?[2,4,6,8,0]\\.log\\.gz");
        for (int i = 0; i < 16; ++i) {
            String str = "test-" + i + ".log.gz";
            Matcher m = p.matcher(str);
            System.out.println(m.matches() + ": " + str);
        }
    }

    public void rolloverTriggered(String fileName) {
        if (fileName.endsWith("test-4.log")) {
            this.fileFound = true;
        }
    }

    public void rolloverComplete(String fileName) {
    }
}

