/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.pattern.AnsiEscape;
import org.apache.logging.log4j.core.pattern.StyleConverter;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.apache.logging.log4j.util.Strings;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class StyleConverterTest {
    private static final String EXPECTED = "\u001b[1;31mERROR\u001b[m \u001b[1;36mLoggerTest\u001b[m o.a.l.l.c.p.StyleConverterTest org.apache.logging.log4j.core.pattern.StyleConverterTest" + Strings.LINE_SEPARATOR;

    @BeforeAll
    public static void beforeClass() {
        System.setProperty("log4j.skipJansi", "false");
    }

    @Test
    @LoggerContextSource(value="log4j-style.xml")
    public void testReplacement(LoggerContext context, @Named(value="List") ListAppender app) {
        Logger logger = context.getLogger("LoggerTest");
        logger.error(this.getClass().getName());
        List<String> msgs = app.getMessages();
        Assertions.assertNotNull(msgs);
        Assertions.assertEquals((int)1, (int)msgs.size(), (String)("Incorrect number of messages. Should be 1 is " + msgs.size()));
        Assertions.assertTrue((boolean)msgs.get(0).endsWith(EXPECTED), (String)("Replacement failed - expected ending " + EXPECTED + ", actual " + msgs.get(0)));
    }

    @Test
    public void testNull() {
        Assertions.assertNull((Object)StyleConverter.newInstance(null, null));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.logging.log4j.core.pattern.HighlightConverterTest#colors"})
    public void testHighlightConverterCompatibility(String color, String escape) {
        StyleConverter converter = StyleConverter.newInstance(null, (String[])new String[]{"Hello!", color});
        StringBuilder sb = new StringBuilder();
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLevel(Level.INFO).build();
        converter.format((LogEvent)event, sb);
        Assertions.assertEquals((Object)(escape + "Hello!" + AnsiEscape.getDefaultStyle()), (Object)sb.toString());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.logging.log4j.core.pattern.HighlightConverterTest#colors"})
    public void testLegacyCommaSeparator(String color, String escape) {
        StyleConverter converter = StyleConverter.newInstance(null, (String[])new String[]{"Hello!", color.replaceAll("\\s+", ",")});
        StringBuilder sb = new StringBuilder();
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLevel(Level.INFO).build();
        converter.format((LogEvent)event, sb);
        Assertions.assertEquals((Object)(escape + "Hello!" + AnsiEscape.getDefaultStyle()), (Object)sb.toString());
    }
}

