/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.apache.logging.log4j.core.pattern.ArrayPatternConverter;
import org.apache.logging.log4j.core.pattern.FormattingInfo;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PatternParserTest2 {
    @Test
    public void testParseConvertBackslashes() {
        boolean convert = true;
        StringBuilder buf = new StringBuilder();
        String pattern = "%d{HH-mm-ss} \\t ...";
        Calendar cal = Calendar.getInstance();
        cal.set(11, 23);
        cal.set(12, 53);
        cal.set(13, 1);
        this.parse("%d{HH-mm-ss} \\t ...", true, buf, cal.getTime(), 123);
        Assertions.assertEquals((Object)"23-53-01 \t ...", (Object)buf.toString());
    }

    @Test
    public void testParseDontConvertBackslashes() {
        boolean convert = false;
        StringBuilder buf = new StringBuilder();
        String pattern = "%d{HH-mm-ss} \\t---";
        Calendar cal = Calendar.getInstance();
        cal.set(11, 13);
        cal.set(12, 24);
        cal.set(13, 59);
        this.parse("%d{HH-mm-ss} \\t---", false, buf, cal.getTime(), 3);
        Assertions.assertEquals((Object)"13-24-59 \\t---", (Object)buf.toString());
    }

    private void parse(String pattern, boolean convert, StringBuilder buf, Date date, int i) {
        PatternParser parser0 = new PatternParser(null, "Converter", null);
        ArrayList converters = new ArrayList();
        ArrayList fields = new ArrayList();
        parser0.parse(pattern, converters, fields, false, false, convert);
        FormattingInfo[] patternFields = fields.toArray(FormattingInfo.EMPTY_ARRAY);
        ArrayPatternConverter[] converterArray = new ArrayPatternConverter[converters.size()];
        ArrayPatternConverter[] patternConverters = converters.toArray(converterArray);
        this.formatFileName(patternConverters, patternFields, buf, date, i);
    }

    protected final void formatFileName(ArrayPatternConverter[] patternConverters, FormattingInfo[] patternFields, StringBuilder buf, Object ... objects) {
        for (int i = 0; i < patternConverters.length; ++i) {
            int fieldStart = buf.length();
            patternConverters[i].format(buf, objects);
            if (patternFields[i] == null) continue;
            patternFields[i].format(fieldStart, buf);
        }
    }
}

