/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import net.javacrumbs.jsonunit.JsonAssert;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.BasicConfigurationFactory;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.layout.GelfLayout;
import org.apache.logging.log4j.core.lookup.JavaLookup;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.core.util.NetUtils;
import org.apache.logging.log4j.junit.UsingAnyThreadContext;
import org.apache.logging.log4j.test.appender.EncodingListAppender;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

@UsingAnyThreadContext
public class GelfLayoutTest {
    static ConfigurationFactory configFactory = new BasicConfigurationFactory();
    private static final String HOSTNAME = "TheHost";
    private static final String KEY1 = "Key1";
    private static final String KEY2 = "Key2";
    private static final String LINE1 = "empty mdc";
    private static final String LINE2 = "filled mdc";
    private static final String LINE3 = "error message";
    private static final String MDCKEY1 = "MdcKey1";
    private static final String MDCKEY2 = "MdcKey2";
    private static final String MDCVALUE1 = "MdcValue1";
    private static final String MDCVALUE2 = "MdcValue2";
    private static final String VALUE1 = "Value1";
    LoggerContext ctx = LoggerContext.getContext();
    Logger root = this.ctx.getRootLogger();

    @AfterAll
    public static void cleanupClass() {
        ConfigurationFactory.removeConfigurationFactory((ConfigurationFactory)configFactory);
    }

    @BeforeAll
    public static void setupClass() {
        ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)configFactory);
        LoggerContext ctx = LoggerContext.getContext();
        ctx.reconfigure();
    }

    private void testCompressedLayout(GelfLayout.CompressionType compressionType, boolean includeStacktrace, boolean includeThreadContext, String host, boolean includeNullDelimiter, boolean includeNewLineDelimiter) throws IOException {
        InputStream inflaterStream2;
        InputStream inflaterStream;
        for (Appender appender : this.root.getAppenders().values()) {
            this.root.removeAppender(appender);
        }
        GelfLayout layout = ((GelfLayout.Builder)GelfLayout.newBuilder().setConfiguration(this.ctx.getConfiguration())).setHost(host).setAdditionalFields(new KeyValuePair[]{new KeyValuePair(KEY1, VALUE1), new KeyValuePair(KEY2, "${java:runtime}")}).setCompressionType(compressionType).setCompressionThreshold(1024).setIncludeStacktrace(includeStacktrace).setIncludeThreadContext(includeThreadContext).setIncludeNullDelimiter(includeNullDelimiter).setIncludeNewLineDelimiter(includeNewLineDelimiter).build();
        ListAppender eventAppender = new ListAppender("Events", null, null, true, false);
        ListAppender rawAppender = new ListAppender("Raw", null, (Layout<? extends Serializable>)layout, true, true);
        ListAppender formattedAppender = new ListAppender("Formatted", null, (Layout<? extends Serializable>)layout, true, false);
        EncodingListAppender encodedAppender = new EncodingListAppender("Encoded", null, (Layout<? extends Serializable>)layout, false, true);
        eventAppender.start();
        rawAppender.start();
        formattedAppender.start();
        encodedAppender.start();
        if (host == null) {
            host = NetUtils.getLocalHostname();
        }
        JavaLookup javaLookup = new JavaLookup();
        this.root.addAppender((Appender)eventAppender);
        this.root.addAppender((Appender)rawAppender);
        this.root.addAppender((Appender)formattedAppender);
        this.root.addAppender((Appender)encodedAppender);
        this.root.setLevel(Level.DEBUG);
        this.root.debug(LINE1);
        ThreadContext.put((String)MDCKEY1, (String)MDCVALUE1);
        ThreadContext.put((String)MDCKEY2, (String)MDCVALUE2);
        this.root.info(LINE2);
        RuntimeException exception = new RuntimeException("some error");
        this.root.error(LINE3, (Throwable)exception);
        formattedAppender.stop();
        List<LogEvent> events = eventAppender.getEvents();
        List<byte[]> raw = rawAppender.getData();
        List<String> messages = formattedAppender.getMessages();
        List<byte[]> raw2 = encodedAppender.getData();
        String threadName = Thread.currentThread().getName();
        String message = messages.get(0);
        if (includeNullDelimiter) {
            Assertions.assertThat((int)message.indexOf(0)).isEqualTo(message.length() - 1);
            message = message.replace('\u0000', '\n');
        }
        JsonAssert.assertJsonEquals((Object)("{\"version\": \"1.1\",\"host\": \"" + host + "\",\"timestamp\": " + GelfLayout.formatTimestamp((long)events.get(0).getTimeMillis()) + ",\"level\": 7,\"_thread\": \"" + threadName + "\",\"_logger\": \"\",\"short_message\": \"" + LINE1 + "\",\"_" + KEY1 + "\": \"" + VALUE1 + "\",\"_" + KEY2 + "\": \"" + javaLookup.getRuntime() + "\"}"), (Object)message);
        message = messages.get(1);
        if (includeNullDelimiter) {
            Assertions.assertThat((int)message.indexOf(0)).isEqualTo(message.length() - 1);
            message = message.replace('\u0000', '\n');
        }
        JsonAssert.assertJsonEquals((Object)("{\"version\": \"1.1\",\"host\": \"" + host + "\",\"timestamp\": " + GelfLayout.formatTimestamp((long)events.get(1).getTimeMillis()) + ",\"level\": 6,\"_thread\": \"" + threadName + "\",\"_logger\": \"\",\"short_message\": \"" + LINE2 + "\"," + (includeThreadContext ? "\"_MdcKey1\": \"MdcValue1\",\"_MdcKey2\": \"MdcValue2\"," : "") + "\"_" + KEY1 + "\": \"" + VALUE1 + "\",\"_" + KEY2 + "\": \"" + javaLookup.getRuntime() + "\"}"), (Object)message);
        byte[] compressed = raw.get(2);
        byte[] compressed2 = raw2.get(2);
        ByteArrayInputStream bais = new ByteArrayInputStream(compressed);
        ByteArrayInputStream bais2 = new ByteArrayInputStream(compressed2);
        switch (compressionType) {
            case GZIP: {
                inflaterStream = new GZIPInputStream(bais);
                inflaterStream2 = new GZIPInputStream(bais2);
                break;
            }
            case ZLIB: {
                inflaterStream = new InflaterInputStream(bais);
                inflaterStream2 = new InflaterInputStream(bais2);
                break;
            }
            case OFF: {
                inflaterStream = bais;
                inflaterStream2 = bais2;
                break;
            }
            default: {
                throw new IllegalStateException("Missing test case clause");
            }
        }
        byte[] uncompressed = IOUtils.toByteArray((InputStream)inflaterStream);
        byte[] uncompressed2 = IOUtils.toByteArray((InputStream)inflaterStream2);
        inflaterStream.close();
        inflaterStream2.close();
        String uncompressedString = new String(uncompressed, layout.getCharset());
        String uncompressedString2 = new String(uncompressed2, layout.getCharset());
        String expected = "{\"version\": \"1.1\",\"host\": \"" + host + "\",\"timestamp\": " + GelfLayout.formatTimestamp((long)events.get(2).getTimeMillis()) + ",\"level\": 3,\"_thread\": \"" + threadName + "\",\"_logger\": \"\",\"short_message\": \"" + LINE3 + "\",\"full_message\": \"" + String.valueOf(JsonStringEncoder.getInstance().quoteAsString(includeStacktrace ? GelfLayout.formatThrowable((Throwable)exception).toString() : exception.toString())) + "\"," + (includeThreadContext ? "\"_MdcKey1\": \"MdcValue1\",\"_MdcKey2\": \"MdcValue2\"," : "") + "\"_" + KEY1 + "\": \"" + VALUE1 + "\",\"_" + KEY2 + "\": \"" + javaLookup.getRuntime() + "\"}";
        if (includeNullDelimiter) {
            org.junit.jupiter.api.Assertions.assertEquals((int)uncompressedString.indexOf(0), (int)(uncompressedString.length() - 1));
            org.junit.jupiter.api.Assertions.assertEquals((int)uncompressedString2.indexOf(0), (int)(uncompressedString2.length() - 1));
            uncompressedString = uncompressedString.replace('\u0000', '\n');
            uncompressedString2 = uncompressedString2.replace('\u0000', '\n');
        }
        if (includeNewLineDelimiter) {
            org.junit.jupiter.api.Assertions.assertEquals((int)uncompressedString.indexOf(10), (int)(uncompressedString.length() - 1));
            org.junit.jupiter.api.Assertions.assertEquals((int)uncompressedString2.indexOf(10), (int)(uncompressedString2.length() - 1));
        }
        JsonAssert.assertJsonEquals((Object)expected, (Object)uncompressedString);
        JsonAssert.assertJsonEquals((Object)expected, (Object)uncompressedString2);
    }

    @Test
    public void testLayoutGzipCompression() throws Exception {
        this.testCompressedLayout(GelfLayout.CompressionType.GZIP, true, true, HOSTNAME, false, false);
    }

    @Test
    public void testLayoutNoCompression() throws Exception {
        this.testCompressedLayout(GelfLayout.CompressionType.OFF, true, true, HOSTNAME, false, false);
    }

    @Test
    public void testLayoutZlibCompression() throws Exception {
        this.testCompressedLayout(GelfLayout.CompressionType.ZLIB, true, true, HOSTNAME, false, false);
    }

    @Test
    public void testLayoutNoStacktrace() throws Exception {
        this.testCompressedLayout(GelfLayout.CompressionType.OFF, false, true, HOSTNAME, false, false);
    }

    @Test
    public void testLayoutNoThreadContext() throws Exception {
        this.testCompressedLayout(GelfLayout.CompressionType.OFF, true, false, HOSTNAME, false, false);
    }

    @Test
    public void testLayoutNoHost() throws Exception {
        this.testCompressedLayout(GelfLayout.CompressionType.OFF, true, true, null, false, false);
    }

    @Test
    public void testLayoutNullDelimiter() throws Exception {
        this.testCompressedLayout(GelfLayout.CompressionType.OFF, false, true, HOSTNAME, true, false);
    }

    @Test
    public void testLayoutNewLineDelimiter() throws Exception {
        this.testCompressedLayout(GelfLayout.CompressionType.OFF, true, true, HOSTNAME, false, true);
    }

    @Test
    public void testFormatTimestamp() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"0", (Object)GelfLayout.formatTimestamp((long)0L).toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1.000", (Object)GelfLayout.formatTimestamp((long)1000L).toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1.001", (Object)GelfLayout.formatTimestamp((long)1001L).toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1.010", (Object)GelfLayout.formatTimestamp((long)1010L).toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1.100", (Object)GelfLayout.formatTimestamp((long)1100L).toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1458741206.653", (Object)GelfLayout.formatTimestamp((long)1458741206653L).toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"9223372036854775.807", (Object)GelfLayout.formatTimestamp((long)Long.MAX_VALUE).toString());
    }

    private void testRequiresLocation(String messagePattern, Boolean requiresLocation) {
        GelfLayout layout = GelfLayout.newBuilder().setMessagePattern(messagePattern).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)layout.requiresLocation(), (Object)requiresLocation);
    }

    @Test
    public void testRequiresLocationPatternNotSet() {
        this.testRequiresLocation(null, false);
    }

    @Test
    public void testRequiresLocationPatternNotContainsLocation() {
        this.testRequiresLocation("%m %n", false);
    }

    @Test
    public void testRequiresLocationPatternContainsLocation() {
        this.testRequiresLocation("%C %m %t", true);
    }
}

