/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.filter.CompositeFilter;
import org.apache.logging.log4j.core.filter.DenyAllFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CompositeFilterTest {
    @Test
    public void testConcatenation() {
        DenyAllFilter a = ((DenyAllFilter.Builder)DenyAllFilter.newBuilder().setOnMatch(Filter.Result.ACCEPT)).build();
        DenyAllFilter b = ((DenyAllFilter.Builder)DenyAllFilter.newBuilder().setOnMatch(Filter.Result.NEUTRAL)).build();
        DenyAllFilter c = ((DenyAllFilter.Builder)DenyAllFilter.newBuilder().setOnMatch(Filter.Result.DENY)).build();
        Assertions.assertNotEquals((Object)a, (Object)b);
        Assertions.assertNotEquals((Object)a, (Object)c);
        Assertions.assertNotEquals((Object)b, (Object)c);
        Object[] expected = new Filter[]{a, b, c};
        CompositeFilter singleA = CompositeFilter.createFilters((Filter[])new Filter[]{a});
        CompositeFilter singleB = CompositeFilter.createFilters((Filter[])new Filter[]{b});
        CompositeFilter singleC = CompositeFilter.createFilters((Filter[])new Filter[]{c});
        CompositeFilter concat1 = singleA.addFilter((Filter)b).addFilter((Filter)c);
        Assertions.assertArrayEquals((Object[])expected, (Object[])concat1.getFiltersArray());
        CompositeFilter concat2 = singleA.addFilter((Filter)singleB.addFilter((Filter)singleC));
        Assertions.assertArrayEquals((Object[])expected, (Object[])concat2.getFiltersArray());
    }
}

