/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.convert;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.appender.rolling.action.Duration;
import org.apache.logging.log4j.core.config.plugins.convert.TypeConverters;
import org.apache.logging.log4j.core.layout.GelfLayout;
import org.apache.logging.log4j.core.net.Facility;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TypeConvertersTest {
    private final String value;
    private final Object expected;
    private final String defaultValue;
    private final Class<?> clazz;

    @Parameterized.Parameters
    public static Collection<Object[]> data() throws Exception {
        byte[] byteArray = new byte[]{-57, 115, 33, -116, 126, -56, -18, -103};
        return Arrays.asList({"true", true, null, Boolean.class}, {"false", false, null, Boolean.class}, {"True", true, null, Boolean.class}, {"TRUE", true, null, Boolean.class}, {"blah", false, null, Boolean.class}, {null, null, null, Boolean.class}, {null, true, "true", Boolean.class}, {"no", false, null, Boolean.class}, {"true", true, "false", Boolean.TYPE}, {"FALSE", false, "true", Boolean.TYPE}, {null, false, "false", Boolean.TYPE}, {"invalid", false, "false", Boolean.TYPE}, {"42", (byte)42, null, Byte.class}, {"53", (byte)53, null, Byte.class}, {"A", Character.valueOf('A'), null, Character.TYPE}, {"b", Character.valueOf('b'), null, Character.TYPE}, {"b0", null, null, Character.TYPE}, {"42", 42, null, Integer.class}, {"53", 53, null, Integer.class}, {"-16", -16, null, Integer.class}, {"0", 0, null, Integer.class}, {"n", null, null, Integer.class}, {"n", 5, "5", Integer.class}, {"4.2", null, null, Integer.class}, {"4.2", 0, "0", Integer.class}, {null, null, null, Integer.class}, {"75", 75, "0", Integer.TYPE}, {"-30", -30, "0", Integer.TYPE}, {"0", 0, "10", Integer.TYPE}, {null, 10, "10", Integer.TYPE}, {"55", 55L, null, Long.class}, {"1234567890123456789", 1234567890123456789L, null, Long.class}, {"123123123L", null, null, Long.class}, {"123123123123", 123123123123L, null, Long.class}, {"-987654321", -987654321L, null, Long.class}, {"-45l", null, null, Long.class}, {"0", 0L, null, Long.class}, {"asdf", null, null, Long.class}, {"3.14", null, null, Long.class}, {"3.14", 0L, "0", Long.class}, {"*3", 1000L, "1000", Long.class}, {null, null, null, Long.class}, {"3000", 3000L, "0", Long.TYPE}, {"-543210", -543210L, "0", Long.TYPE}, {"22.7", -53L, "-53", Long.TYPE}, {"42", (short)42, null, Short.TYPE}, {"53", (short)53, null, Short.TYPE}, {"-16", (short)-16, null, Short.class}, {"ERROR", Level.ERROR, null, Level.class}, {"WARN", Level.WARN, null, Level.class}, {"FOO", null, null, Level.class}, {"FOO", Level.DEBUG, "DEBUG", Level.class}, {"OFF", Level.OFF, null, Level.class}, {null, null, null, Level.class}, {null, Level.INFO, "INFO", Level.class}, {"ACCEPT", Filter.Result.ACCEPT, null, Filter.Result.class}, {"NEUTRAL", Filter.Result.NEUTRAL, null, Filter.Result.class}, {"DENY", Filter.Result.DENY, null, Filter.Result.class}, {"NONE", null, null, Filter.Result.class}, {"NONE", Filter.Result.NEUTRAL, "NEUTRAL", Filter.Result.class}, {null, null, null, Filter.Result.class}, {null, Filter.Result.ACCEPT, "ACCEPT", Filter.Result.class}, {"KERN", Facility.KERN, "USER", Facility.class}, {"mail", Facility.MAIL, "KERN", Facility.class}, {"Cron", Facility.CRON, null, Facility.class}, {"not a real facility", Facility.AUTH, "auth", Facility.class}, {null, null, null, Facility.class}, {"GZIP", GelfLayout.CompressionType.GZIP, "GZIP", GelfLayout.CompressionType.class}, {"ZLIB", GelfLayout.CompressionType.ZLIB, "GZIP", GelfLayout.CompressionType.class}, {"OFF", GelfLayout.CompressionType.OFF, "GZIP", GelfLayout.CompressionType.class}, {"123", "123".toCharArray(), null, char[].class}, {"123", "123".getBytes(Charset.defaultCharset()), null, byte[].class}, {"0xC773218C7EC8EE99", byteArray, null, byte[].class}, {"0xc773218c7ec8ee99", byteArray, null, byte[].class}, {"Base64:cGxlYXN1cmUu", "pleasure.".getBytes("US-ASCII"), null, byte[].class}, {"UTF-8", StandardCharsets.UTF_8, null, Charset.class}, {"ASCII", Charset.forName("ASCII"), "UTF-8", Charset.class}, {"Not a real charset", StandardCharsets.UTF_8, "UTF-8", Charset.class}, {null, StandardCharsets.UTF_8, "UTF-8", Charset.class}, {null, null, null, Charset.class}, {"c:/temp", new File("c:/temp"), null, File.class}, {TypeConvertersTest.class.getName(), TypeConvertersTest.class, null, Class.class}, {"boolean", Boolean.TYPE, null, Class.class}, {"byte", Byte.TYPE, null, Class.class}, {"char", Character.TYPE, null, Class.class}, {"double", Double.TYPE, null, Class.class}, {"float", Float.TYPE, null, Class.class}, {"int", Integer.TYPE, null, Class.class}, {"long", Long.TYPE, null, Class.class}, {"short", Short.TYPE, null, Class.class}, {"void", Void.TYPE, null, Class.class}, {"\t", Object.class, Object.class.getName(), Class.class}, {"\n", null, null, Class.class}, {"http://locahost", new URL("http://locahost"), null, URL.class}, {"\n", null, null, URL.class}, {"http://locahost", new URI("http://locahost"), null, URI.class}, {"\n", null, null, URI.class}, {"9223372036854775817000", new BigInteger("9223372036854775817000"), null, BigInteger.class}, {"\n", null, null, BigInteger.class}, {"9223372036854775817000.99999", new BigDecimal("9223372036854775817000.99999"), null, BigDecimal.class}, {"\n", null, null, BigDecimal.class}, {Security.getProviders()[0].getName(), Security.getProviders()[0], null, Provider.class}, {"\n", null, null, Provider.class}, {"P7DT10H", Duration.parse((CharSequence)"P7DT10H"), null, Duration.class}, {"127.0.0.1", InetAddress.getByName("127.0.0.1"), null, InetAddress.class}, {"/path/to/file", Paths.get("/path", "to", "file"), null, Path.class}, {"8fd389fb-9154-4096-b52e-435bde4a1835", UUID.fromString("8fd389fb-9154-4096-b52e-435bde4a1835"), null, UUID.class});
    }

    public TypeConvertersTest(String value, Object expected, String defaultValue, Class<?> clazz) {
        this.value = value;
        this.expected = expected;
        this.defaultValue = defaultValue;
        this.clazz = clazz;
    }

    @Test
    public void testConvert() throws Exception {
        Object actual = TypeConverters.convert((String)this.value, this.clazz, (Object)this.defaultValue);
        String assertionMessage = "\nGiven: " + this.value + "\nDefault: " + this.defaultValue;
        if (this.expected instanceof char[]) {
            Assert.assertArrayEquals((String)assertionMessage, (char[])((char[])this.expected), (char[])((char[])actual));
        } else if (this.expected instanceof byte[]) {
            Assert.assertArrayEquals((String)assertionMessage, (byte[])((byte[])this.expected), (byte[])((byte[])actual));
        } else {
            Assert.assertEquals((String)assertionMessage, (Object)this.expected, (Object)actual);
        }
    }
}

