/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.NullConfiguration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LoggerConfigTest {
    private static LoggerConfig createForProperties(Property[] properties) {
        return LoggerConfig.createLogger((boolean)true, (Level)Level.INFO, (String)"name", (String)"false", (AppenderRef[])new AppenderRef[0], (Property[])properties, (Configuration)new NullConfiguration(), null);
    }

    @Test
    public void testPropertiesWithoutSubstitution() {
        Assertions.assertNull((Object)LoggerConfigTest.createForProperties(null).getPropertyList(), (String)"null propertiesList");
        Property[] all = new Property[]{Property.createProperty((String)"key1", (String)"value1"), Property.createProperty((String)"key2", (String)"value2")};
        LoggerConfig loggerConfig = LoggerConfigTest.createForProperties(all);
        List list = loggerConfig.getPropertyList();
        Assertions.assertEquals(new HashSet(list), new HashSet(loggerConfig.getPropertyList()), (String)"map and list contents equal");
        AtomicReference actualList = new AtomicReference();
        loggerConfig.setLogEventFactory((loggerName, marker, fqcn, level, data, properties, t) -> {
            actualList.set(properties);
            return new Log4jLogEvent.Builder().setTimeMillis(System.currentTimeMillis()).build();
        });
        loggerConfig.log("name", "fqcn", null, Level.INFO, (Message)new SimpleMessage("msg"), null);
        Assertions.assertSame((Object)list, actualList.get(), (String)"propertiesList passed in as is if no substitutions required");
    }

    @Test
    public void testPropertiesWithSubstitution() {
        Property[] all = new Property[]{Property.createProperty((String)"key1", (String)"value1-${sys:user.name}"), Property.createProperty((String)"key2", (String)"value2-${sys:user.name}")};
        LoggerConfig loggerConfig = LoggerConfigTest.createForProperties(all);
        List list = loggerConfig.getPropertyList();
        Assertions.assertEquals(new HashSet(list), new HashSet(loggerConfig.getPropertyList()), (String)"map and list contents equal");
        AtomicReference actualListHolder = new AtomicReference();
        loggerConfig.setLogEventFactory((loggerName, marker, fqcn, level, data, properties, t) -> {
            actualListHolder.set(properties);
            return new Log4jLogEvent.Builder().setTimeMillis(System.currentTimeMillis()).build();
        });
        loggerConfig.log("name", "fqcn", null, Level.INFO, (Message)new SimpleMessage("msg"), null);
        Assertions.assertNotSame((Object)list, actualListHolder.get(), (String)"propertiesList with substitutions");
        List actualList = (List)actualListHolder.get();
        for (int i = 0; i < list.size(); ++i) {
            Assertions.assertEquals((Object)((Property)list.get(i)).getName(), (Object)((Property)actualList.get(i)).getName(), (String)("name[" + i + "]"));
            String value = ((Property)list.get(i)).getValue().replace("${sys:user.name}", System.getProperty("user.name"));
            Assertions.assertEquals((Object)value, (Object)((Property)actualList.get(i)).getValue(), (String)("value[" + i + "]"));
        }
    }

    @Test
    public void testLevel() {
        DefaultConfiguration configuration = new DefaultConfiguration();
        LoggerConfig config1 = LoggerConfig.newBuilder().withLoggerName("org.apache.logging.log4j.test").withLevel(Level.ERROR).withAdditivity(false).withConfig((Configuration)configuration).build();
        LoggerConfig config2 = LoggerConfig.newBuilder().withLoggerName("org.apache.logging.log4j").withAdditivity(false).withConfig((Configuration)configuration).build();
        config1.setParent(config2);
        Assertions.assertEquals((Object)config1.getLevel(), (Object)Level.ERROR, (String)"Unexpected Level");
        Assertions.assertEquals((Object)config1.getExplicitLevel(), (Object)Level.ERROR, (String)"Unexpected explicit level");
        Assertions.assertEquals((Object)config2.getLevel(), (Object)Level.ERROR, (String)"Unexpected Level");
        Assertions.assertNull((Object)config2.getExplicitLevel(), (String)"Unexpected explicit level");
    }
}

