/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverListener;
import org.apache.logging.log4j.core.config.Configurator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class RollingDirectSize3490Test
implements RolloverListener {
    private static final String CONFIG = "log4j-rolling-3490.xml";
    private static final String[] set1 = new String[]{"This is file 1"};
    private static final String LINE_2 = "This is file 2\n";
    private static final String DIR = "target/rolling-3490";
    private boolean rolloverTriggered = false;

    @BeforeAll
    public static void clean() throws Exception {
        File dir = new File(DIR);
        if (dir.exists()) {
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    file.delete();
                }
            }
            dir.delete();
        }
    }

    @Test
    public void rolloverTest() throws Exception {
        File parent = new File(DIR);
        parent.mkdirs();
        Path app1 = new File(parent, "app-21.log").toPath();
        Files.write(app1, Arrays.asList(set1), StandardOpenOption.CREATE_NEW);
        ArrayList<String> lines = new ArrayList<String>();
        for (int count = 0; count < 1024; count += LINE_2.length()) {
            lines.add(LINE_2);
        }
        File file2 = new File(parent, "app-22.log");
        Path app2 = file2.toPath();
        Files.write(app2, lines, StandardOpenOption.CREATE_NEW);
        LoggerContext context = Configurator.initialize((String)"TestConfig", (ClassLoader)this.getClass().getClassLoader(), (String)CONFIG);
        RollingFileAppender app = (RollingFileAppender)context.getConfiguration().getAppender("RollingFile");
        ((RollingFileManager)app.getManager()).addRolloverListener((RolloverListener)this);
        Logger logger = context.getLogger("Test");
        logger.info("Trigger rollover");
        Assertions.assertTrue((boolean)this.rolloverTriggered, (String)"Rollover was not triggered");
    }

    public void rolloverTriggered(String fileName) {
    }

    public void rolloverComplete(String fileName) {
        Assertions.assertTrue((boolean)fileName.endsWith("app-22.log"), (String)"File does not end with correct suffix");
        this.rolloverTriggered = true;
    }
}

