/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.jdbc;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.core.appender.db.jdbc.AbstractConnectionSource;
import org.apache.logging.log4j.core.appender.db.jdbc.ConnectionSource;

public class JdbcH2TestHelper {
    static final String CONNECTION_STRING_IN_MEMORY = "jdbc:h2:mem:Log4j";
    static final String CONNECTION_STRING_TEMP_DIR = "jdbc:h2:" + JdbcH2TestHelper.getH2Path() + "/test_log4j;TRACE_LEVEL_SYSTEM_OUT=0";
    static final String USER_NAME = "sa";
    static final String PASSWORD = "";
    public static ConnectionSource TEST_CONFIGURATION_SOURCE_MEM = new AbstractConnectionSource(){

        public Connection getConnection() throws SQLException {
            return JdbcH2TestHelper.getConnectionInMemory();
        }
    };
    public static ConnectionSource TEST_CONFIGURATION_SOURCE_TMPDIR = new AbstractConnectionSource(){

        public Connection getConnection() throws SQLException {
            return JdbcH2TestHelper.getConnectionTempDir();
        }
    };
    static final String H2_TEST_RELATIVE_DIR = "h2";

    static void deleteDir() throws IOException {
        Path resolve = JdbcH2TestHelper.getH2Path();
        if (Files.exists(resolve, new LinkOption[0])) {
            PathUtils.deleteDirectory((Path)resolve);
        }
    }

    public static Connection getConnectionInMemory() throws SQLException {
        return DriverManager.getConnection(CONNECTION_STRING_IN_MEMORY, USER_NAME, PASSWORD);
    }

    public static Connection getConnectionTempDir() throws SQLException {
        return DriverManager.getConnection(CONNECTION_STRING_TEMP_DIR, USER_NAME, PASSWORD);
    }

    private static Path getH2Path() {
        return SystemUtils.getJavaIoTmpDir().toPath().resolve(H2_TEST_RELATIVE_DIR).normalize();
    }
}

