/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.util.Properties;
import org.apache.logging.log4j.core.net.JndiManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JndiManagerTest {
    private static final String TRUE = "true";

    @Test
    public void testIsJndiContextSelectorEnabled() {
        Assertions.assertFalse((boolean)JndiManager.isJndiContextSelectorEnabled());
        try {
            System.setProperty("log4j2.enableJndiContextSelector", TRUE);
            Assertions.assertTrue((boolean)JndiManager.isJndiContextSelectorEnabled());
        }
        finally {
            System.clearProperty("log4j2.enableJndiContextSelector");
        }
    }

    @Test
    public void testIsJndiEnabled() {
        Assertions.assertFalse((boolean)JndiManager.isJndiEnabled());
        try {
            System.setProperty("log4j2.enableJndiJms", TRUE);
            Assertions.assertTrue((boolean)JndiManager.isJndiEnabled());
        }
        finally {
            System.clearProperty("log4j2.enableJndiJms");
        }
    }

    @Test
    public void testIsJndiJdbcEnabled() {
        Assertions.assertFalse((boolean)JndiManager.isJndiJdbcEnabled());
        try {
            System.setProperty("log4j2.enableJndiJdbc", TRUE);
            Assertions.assertTrue((boolean)JndiManager.isJndiJdbcEnabled());
        }
        finally {
            System.clearProperty("log4j2.enableJndiJdbc");
        }
    }

    @Test
    public void testIsJndiJmsEnabled() {
        Assertions.assertFalse((boolean)JndiManager.isJndiJmsEnabled());
        try {
            System.setProperty("log4j2.enableJndiJms", TRUE);
            Assertions.assertTrue((boolean)JndiManager.isJndiJmsEnabled());
        }
        finally {
            System.clearProperty("log4j2.enableJndiJms");
        }
    }

    @Test
    public void testIsJndiLookupEnabled() {
        Assertions.assertFalse((boolean)JndiManager.isJndiLookupEnabled());
    }

    @Test
    public void testNoInstanceByDefault() {
        Assertions.assertThrows(IllegalStateException.class, () -> JndiManager.getDefaultManager());
        Assertions.assertThrows(IllegalStateException.class, () -> JndiManager.getDefaultManager(null));
        Assertions.assertThrows(IllegalStateException.class, () -> JndiManager.getDefaultManager((String)"A"));
        Assertions.assertThrows(IllegalStateException.class, () -> JndiManager.getJndiManager(null));
        Assertions.assertThrows(IllegalStateException.class, () -> JndiManager.getJndiManager((Properties)new Properties()));
        Assertions.assertThrows(IllegalStateException.class, () -> JndiManager.getJndiManager(null, null, null, null, null, null));
        Assertions.assertThrows(IllegalStateException.class, () -> JndiManager.getJndiManager((String)"A", (String)"A", (String)"A", (String)"A", (String)"A", (Properties)new Properties()));
    }
}

