/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.AbstractLogEvent;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.BasicConfigurationFactory;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.layout.HtmlLayout;
import org.apache.logging.log4j.core.time.MutableInstant;
import org.apache.logging.log4j.core.util.datetime.FixedDateFormat;
import org.apache.logging.log4j.junit.UsingAnyThreadContext;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

@UsingAnyThreadContext
public class HtmlLayoutTest {
    private final LoggerContext ctx = LoggerContext.getContext();
    private final Logger root = this.ctx.getRootLogger();
    static ConfigurationFactory cf = new BasicConfigurationFactory();
    private static final String body = "<tr><td bgcolor=\"#993300\" style=\"color:White; font-size : small;\" colspan=\"6\">java.lang.NullPointerException: test";
    private static final String multiLine = "<td title=\"Message\">First line<br />Second line</td>";

    @BeforeAll
    public static void setupClass() {
        ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)cf);
        LoggerContext ctx = LoggerContext.getContext();
        ctx.reconfigure();
    }

    @AfterAll
    public static void cleanupClass() {
        ConfigurationFactory.removeConfigurationFactory((ConfigurationFactory)cf);
    }

    @Test
    public void testDefaultContentType() {
        HtmlLayout layout = HtmlLayout.createDefaultLayout();
        Assertions.assertEquals((Object)"text/html; charset=UTF-8", (Object)layout.getContentType());
    }

    @Test
    public void testContentType() {
        HtmlLayout layout = HtmlLayout.newBuilder().withContentType("text/html; charset=UTF-16").build();
        Assertions.assertEquals((Object)"text/html; charset=UTF-16", (Object)layout.getContentType());
    }

    @Test
    public void testDefaultCharset() {
        HtmlLayout layout = HtmlLayout.createDefaultLayout();
        Assertions.assertEquals((Object)StandardCharsets.UTF_8, (Object)layout.getCharset());
    }

    @Test
    public void testLayoutIncludeLocationNo() throws Exception {
        this.testLayout(false);
    }

    @Test
    public void testLayoutIncludeLocationYes() throws Exception {
        this.testLayout(true);
    }

    private void testLayout(boolean includeLocation) throws Exception {
        String string2;
        Object appender2;
        Map appenders = this.root.getAppenders();
        for (Object appender2 : appenders.values()) {
            this.root.removeAppender((Appender)appender2);
        }
        HtmlLayout layout = HtmlLayout.newBuilder().withLocationInfo(includeLocation).build();
        appender2 = new ListAppender("List", null, (Layout<? extends Serializable>)layout, true, false);
        appender2.start();
        this.root.addAppender((Appender)appender2);
        this.root.setLevel(Level.DEBUG);
        this.root.debug("starting mdc pattern test");
        this.root.debug("empty mdc");
        this.root.debug("First line\nSecond line");
        ThreadContext.put((String)"key1", (String)"value1");
        ThreadContext.put((String)"key2", (String)"value2");
        this.root.debug("filled mdc");
        ThreadContext.remove((String)"key1");
        ThreadContext.remove((String)"key2");
        this.root.error("finished mdc pattern test", (Throwable)new NullPointerException("test"));
        appender2.stop();
        List<String> list = ((ListAppender)((Object)appender2)).getMessages();
        StringBuilder sb = new StringBuilder();
        for (String string2 : list) {
            sb.append(string2);
        }
        String html = sb.toString();
        Assertions.assertTrue((list.size() > 85 ? 1 : 0) != 0, (String)("Incorrect number of lines. Require at least 85 " + list.size()));
        string2 = list.get(3);
        Assertions.assertEquals((Object)"<meta charset=\"UTF-8\"/>", (Object)string2, (String)("Incorrect header: " + string2));
        Assertions.assertEquals((Object)"<title>Log4j Log Messages</title>", (Object)list.get(4), (String)"Incorrect title");
        Assertions.assertEquals((Object)"</body></html>", (Object)list.get(list.size() - 1), (String)"Incorrect footer");
        if (includeLocation) {
            Assertions.assertEquals((Object)list.get(50), (Object)multiLine, (String)"Incorrect multiline");
            Assertions.assertTrue((boolean)html.contains("HtmlLayoutTest.java:"), (String)"Missing location");
            Assertions.assertEquals((Object)list.get(71), (Object)body, (String)"Incorrect body");
        } else {
            Assertions.assertFalse((boolean)html.contains("<td>HtmlLayoutTest.java:"), (String)"Location should not be in the output table");
        }
        for (Appender app : appenders.values()) {
            this.root.addAppender(app);
        }
    }

    @Test
    public void testLayoutWithoutDataPattern() {
        HtmlLayout layout = HtmlLayout.newBuilder().build();
        MyLogEvent event = new MyLogEvent();
        String actual = this.getDateLine(layout.toSerializable((LogEvent)event));
        long jvmStratTime = ManagementFactory.getRuntimeMXBean().getStartTime();
        Assertions.assertEquals((Object)("<td>" + (event.getTimeMillis() - jvmStratTime) + "</td>"), (Object)actual, (String)("Incorrect date:" + actual));
    }

    @Test
    public void testLayoutWithDatePatternJvmElapseTime() {
        HtmlLayout layout = HtmlLayout.newBuilder().setDatePattern("JVM_ELAPSE_TIME").build();
        MyLogEvent event = new MyLogEvent();
        String actual = this.getDateLine(layout.toSerializable((LogEvent)event));
        long jvmStratTime = ManagementFactory.getRuntimeMXBean().getStartTime();
        Assertions.assertEquals((Object)("<td>" + (event.getTimeMillis() - jvmStratTime) + "</td>"), (Object)actual, (String)("Incorrect date:" + actual));
    }

    @Test
    public void testLayoutWithDatePatternUnix() {
        HtmlLayout layout = HtmlLayout.newBuilder().setDatePattern("UNIX").build();
        MyLogEvent event = new MyLogEvent();
        String actual = this.getDateLine(layout.toSerializable((LogEvent)event));
        Assertions.assertEquals((Object)("<td>" + event.getInstant().getEpochSecond() + "</td>"), (Object)actual, (String)("Incorrect date:" + actual));
    }

    @Test
    public void testLayoutWithDatePatternUnixMillis() {
        HtmlLayout layout = HtmlLayout.newBuilder().setDatePattern("UNIX_MILLIS").build();
        MyLogEvent event = new MyLogEvent();
        String actual = this.getDateLine(layout.toSerializable((LogEvent)event));
        Assertions.assertEquals((Object)("<td>" + event.getTimeMillis() + "</td>"), (Object)actual, (String)("Incorrect date:" + actual));
    }

    @Test
    public void testLayoutWithDatePatternFixedFormat() {
        for (String timeZone : new String[]{"GMT+8", "UTC", null}) {
            for (FixedDateFormat.FixedFormat format : FixedDateFormat.FixedFormat.values()) {
                this.testLayoutWithDatePatternFixedFormat(format, timeZone);
            }
        }
    }

    private String getDateLine(String logEventString) {
        return logEventString.split(System.lineSeparator())[2];
    }

    private void testLayoutWithDatePatternFixedFormat(FixedDateFormat.FixedFormat format, String timezone) {
        HtmlLayout layout = HtmlLayout.newBuilder().setDatePattern(format.name()).setTimezone(timezone).build();
        MyLogEvent event = new MyLogEvent();
        String actual = this.getDateLine(layout.toSerializable((LogEvent)event));
        Instant instant = Instant.ofEpochSecond(event.getInstant().getEpochSecond(), event.getInstant().getNanoOfSecond());
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
        if (timezone != null) {
            zonedDateTime = zonedDateTime.withZoneSameInstant(ZoneId.of(timezone));
        }
        Locale formatLocale = Locale.getDefault(Locale.Category.FORMAT);
        Locale locale = Locale.getDefault().equals(formatLocale) ? formatLocale : Locale.getDefault();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format.getPattern().replace('n', 'S').replace('X', 'x'), locale);
        String expected = zonedDateTime.format(dateTimeFormatter);
        Assertions.assertEquals((Object)("<td>" + expected + "</td>"), (Object)actual, (String)MessageFormat.format("Incorrect date={0}, format={1}, timezone={2}", actual, format.name(), timezone));
    }

    private static class MyLogEvent
    extends AbstractLogEvent {
        private static final long serialVersionUID = 0L;

        private MyLogEvent() {
        }

        public org.apache.logging.log4j.core.time.Instant getInstant() {
            MutableInstant result = new MutableInstant();
            result.initFromEpochMilli(this.getTimeMillis(), 456789);
            return result;
        }

        public long getTimeMillis() {
            Calendar cal = Calendar.getInstance();
            cal.set(2012, 10, 2, 14, 34, 2);
            cal.set(14, 123);
            return cal.getTimeInMillis();
        }

        public Level getLevel() {
            return Level.DEBUG;
        }

        public Message getMessage() {
            return new SimpleMessage("msg");
        }
    }
}

