/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@LoggerContextSource(value="configPropertyTest.xml")
public class PropertyTest {
    @Test
    public void testEmptyAttribute(@Named(value="List") ListAppender app) throws Exception {
        Logger logger = LogManager.getLogger();
        logger.info("msg");
        List<String> messages = app.getMessages();
        Assertions.assertNotNull(messages, (String)"No Messages");
        Assertions.assertEquals((int)1, (int)messages.size(), (String)("message count" + messages));
        String expect = "1=elementValue,2=,a=,b=,3=attributeValue,4=attributeValue2,5=elementValue3,m=msg";
        Assertions.assertEquals((Object)"1=elementValue,2=,a=,b=,3=attributeValue,4=attributeValue2,5=elementValue3,m=msg", (Object)messages.get(0));
        app.clear();
    }

    @Test
    public void testPropertyValues() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        StrSubstitutor sub = ctx.getConfiguration().getStrSubstitutor();
        Assertions.assertEquals((Object)"", (Object)sub.replace("${emptyElementKey}"));
        Assertions.assertEquals((Object)"", (Object)sub.replace("${emptyAttributeKey}"));
        Assertions.assertEquals((Object)"", (Object)sub.replace("${emptyAttributeKey2}"));
        Assertions.assertEquals((Object)"elementValue", (Object)sub.replace("${elementKey}"));
        Assertions.assertEquals((Object)"attributeValue", (Object)sub.replace("${attributeKey}"));
        Assertions.assertEquals((Object)"attributeValue2", (Object)sub.replace("${attributeWithEmptyElementKey}"));
        Assertions.assertEquals((Object)"elementValue3", (Object)sub.replace("${bothElementAndAttributeKey}"));
    }

    @Test
    public void testLoggerPropertyValues() throws Exception {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        List rootLoggerProperties = ctx.getConfiguration().getLoggerConfig("root").getPropertyList();
        Assertions.assertEquals((int)9, (int)rootLoggerProperties.size());
        PropertyTest.verifyProperty((Property)rootLoggerProperties.get(0), "emptyElementKey", "", "");
        PropertyTest.verifyProperty((Property)rootLoggerProperties.get(1), "emptyAttributeKey", "", "");
        PropertyTest.verifyProperty((Property)rootLoggerProperties.get(2), "emptyAttributeKey2", "", "");
        PropertyTest.verifyProperty((Property)rootLoggerProperties.get(3), "elementKey", "elementValue", "elementValue");
        PropertyTest.verifyProperty((Property)rootLoggerProperties.get(4), "attributeKey", "attributeValue", "attributeValue");
        PropertyTest.verifyProperty((Property)rootLoggerProperties.get(5), "attributeWithEmptyElementKey", "attributeValue2", "attributeValue2");
        PropertyTest.verifyProperty((Property)rootLoggerProperties.get(6), "bothElementAndAttributeKey", "elementValue3", "elementValue3");
        PropertyTest.verifyProperty((Property)rootLoggerProperties.get(7), "attributeWithLookup", "${lower:ATTR}", "attr");
        PropertyTest.verifyProperty((Property)rootLoggerProperties.get(8), "elementWithLookup", "${lower:ELEMENT}", "element");
    }

    private static void verifyProperty(Property property, String expectedName, String expectedRawValue, String expectedValue) {
        Assertions.assertEquals((Object)expectedName, (Object)property.getName());
        Assertions.assertEquals((Object)expectedRawValue, (Object)property.getRawValue());
        Assertions.assertEquals((Object)expectedValue, (Object)property.getValue());
    }

    @Test
    public void testNullValueIsConvertedToEmptyString() {
        Assertions.assertEquals((Object)"", (Object)Property.createProperty((String)"name", null).getValue());
    }

    @Test
    public void testIsValueNeedsLookup() {
        Assertions.assertTrue((boolean)Property.createProperty((String)"", (String)"${").isValueNeedsLookup(), (String)"with ${ as value");
        Assertions.assertTrue((boolean)Property.createProperty((String)"", (String)"blah${blah").isValueNeedsLookup(), (String)"with ${ in value");
        Assertions.assertFalse((boolean)Property.createProperty((String)"", (String)"").isValueNeedsLookup(), (String)"empty value");
        Assertions.assertFalse((boolean)Property.createProperty((String)"", (String)"blahblah").isValueNeedsLookup(), (String)"without ${ in value");
        Assertions.assertFalse((boolean)Property.createProperty((String)"", (String)"blahb{sys:lah").isValueNeedsLookup(), (String)"without $ in value");
        Assertions.assertFalse((boolean)Property.createProperty((String)"", (String)"blahb$sys:lah").isValueNeedsLookup(), (String)"without { in value");
    }
}

