/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.junit.CleanFolders;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class RollingFileAppenderInterruptedThreadTest {
    private static final String ROLLING_APPENDER_FILES_DIR = "target/" + RollingFileAppenderInterruptedThreadTest.class.getSimpleName();
    @Rule
    public CleanFolders cleanFolders = new CleanFolders(true, false, 3, ROLLING_APPENDER_FILES_DIR);
    LoggerContext loggerContext;

    @Before
    public void setUp() {
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        builder.setConfigurationName("LOG4J2-1798 test");
        builder.add((AppenderComponentBuilder)builder.newAppender("consoleLog", "Console").addAttribute("target", (Enum)ConsoleAppender.Target.SYSTEM_ERR));
        builder.add((AppenderComponentBuilder)((AppenderComponentBuilder)builder.newAppender("fileAppender", "RollingFile").addAttribute("filePattern", ROLLING_APPENDER_FILES_DIR + "/file-%i.log")).add((LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "%msg%n")).addComponent(builder.newComponent("SizeBasedTriggeringPolicy").addAttribute("size", "20B")));
        builder.add((RootLoggerComponentBuilder)((RootLoggerComponentBuilder)builder.newRootLogger(Level.INFO).add(builder.newAppenderRef("consoleLog"))).add(builder.newAppenderRef("fileAppender")));
        this.loggerContext = Configurator.initialize((Configuration)((Configuration)builder.build()));
    }

    @After
    public void tearDown() {
        Configurator.shutdown((LoggerContext)this.loggerContext);
        this.loggerContext = null;
    }

    @Test
    public void testRolloverInInterruptedThread() {
        Logger logger = this.loggerContext.getLogger(this.getClass().getName());
        Assert.assertThat(logger.getAppenders().values(), (Matcher)Matchers.hasItem((Matcher)Matchers.instanceOf(RollingFileAppender.class)));
        logger.info("Sending logging event 1");
        Thread.currentThread().interrupt();
        logger.info("Sending logging event 2");
        Assert.assertTrue((boolean)new File(ROLLING_APPENDER_FILES_DIR, "file-1.log").exists());
        Assert.assertTrue((boolean)new File(ROLLING_APPENDER_FILES_DIR, "file-2.log").exists());
    }
}

