/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverListener;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class RollingAppenderDirectCronTest {
    private static final String CONFIG = "log4j-rolling-direct-cron.xml";
    private static final String DIR = "target/rolling-direct-cron";
    private final LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("log4j-rolling-direct-cron.xml");
    @Rule
    public RuleChain chain = this.loggerContextRule.withCleanFoldersRule("target/rolling-direct-cron");
    private final Pattern filePattern = Pattern.compile(".*(\\d\\d-\\d\\d-\\d\\d-\\d\\d-\\d\\d-\\d\\d).*$");

    @Test
    public void testAppender() throws Exception {
        RollingFileAppender app = (RollingFileAppender)this.loggerContextRule.getAppender("RollingFile");
        Logger logger = this.loggerContextRule.getLogger();
        logger.debug("This is test message number 1");
        RolloverDelay delay = new RolloverDelay((RollingFileManager)app.getManager());
        delay.waitForRollover();
        File dir = new File(DIR);
        File[] files = dir.listFiles();
        Assert.assertTrue((String)"Directory not created", (dir.exists() && files != null && files.length > 0 ? 1 : 0) != 0);
        delay.reset(3);
        int MAX_TRIES = 30;
        for (int i = 0; i < 30; ++i) {
            logger.debug("Adding new event {}", (Object)i);
            Thread.sleep(100L);
        }
        delay.waitForRollover();
    }

    private class RolloverDelay
    implements RolloverListener {
        private volatile CountDownLatch latch = new CountDownLatch(1);

        public RolloverDelay(RollingFileManager manager) {
            manager.addRolloverListener((RolloverListener)this);
        }

        public void waitForRollover() {
            try {
                if (!this.latch.await(3L, TimeUnit.SECONDS)) {
                    Assert.fail((String)"failed to rollover");
                }
            }
            catch (InterruptedException ex) {
                Assert.fail((String)"failed to rollover");
            }
        }

        public void reset(int count) {
            this.latch = new CountDownLatch(count);
        }

        public void rolloverTriggered(String fileName) {
        }

        public void rolloverComplete(String fileName) {
            Matcher matcher = RollingAppenderDirectCronTest.this.filePattern.matcher(fileName);
            Assert.assertTrue((String)("Invalid file name: " + fileName), (boolean)matcher.matches());
            Path path = new File(fileName).toPath();
            try {
                List<String> lines = Files.readAllLines(path);
                Assert.assertTrue((String)("Not enough lines in " + fileName + ":" + lines.size()), (lines.size() > 0 ? 1 : 0) != 0);
                Assert.assertTrue((String)("log and file times don't match. file: " + matcher.group(1) + ", log: " + lines.get(0)), (boolean)lines.get(0).startsWith(matcher.group(1)));
            }
            catch (IOException ex) {
                Assert.fail((String)("Unable to read file " + fileName + ": " + ex.getMessage()));
            }
            this.latch.countDown();
        }
    }
}

