/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.logging.log4j.core.util.Source;
import org.junit.Assert;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class SourceTest {
    @Test
    public void testEqualityFile() {
        Assert.assertEquals((Object)new Source(new File("foo")), (Object)new Source(new File("foo")));
        Assert.assertEquals((Object)new Source(new File("foo")), (Object)new Source(new File("./foo")));
        Assert.assertEquals((Object)new Source(new File("foo.txt")), (Object)new Source(new File("./foo.txt")));
    }

    @Test
    public void testEqualityPath() {
        Assert.assertEquals((Object)new Source(Paths.get("foo", new String[0])), (Object)new Source(Paths.get("foo", new String[0])));
        Assert.assertEquals((Object)new Source(Paths.get("foo", new String[0])), (Object)new Source(Paths.get("./foo", new String[0])));
        Assert.assertEquals((Object)new Source(Paths.get("foo.txt", new String[0])), (Object)new Source(Paths.get("./foo.txt", new String[0])));
    }

    @Test
    @Disabled(value="File URI is broken.")
    public void testEqualityURIFile() {
        Assert.assertEquals((Object)new Source(Paths.get("foo", new String[0]).toUri()), (Object)new Source(Paths.get("./foo", new String[0]).toUri()));
    }

    @Test
    public void testEqualityURIHttp() {
        Assert.assertEquals((Object)new Source(URI.create("http://www.apache.org/index.html")), (Object)new Source(URI.create("http://www.apache.org/index.html")));
        Assert.assertEquals((Object)new Source(URI.create("http://www.apache.org/")), (Object)new Source(URI.create("http://www.apache.org////")));
        Assert.assertEquals((Object)new Source(URI.create("http://www.apache.org/")), (Object)new Source(URI.create("http://www.apache.org/./././.")));
    }

    public void testEqualityURLFile() throws MalformedURLException {
        Assert.assertEquals((Object)new Source(Paths.get("foo", new String[0]).toUri().toURL()), (Object)new Source(Paths.get("./foo", new String[0]).toUri().toURL()));
    }

    public void testEqualityURLHttp() throws MalformedURLException {
        Assert.assertEquals((Object)new Source(URI.create("http://www.apache.org/index.html").toURL()), (Object)new Source(URI.create("http://www.apache.org/index.html").toURL()));
        Assert.assertEquals((Object)new Source(URI.create("http://www.apache.org").toURL()), (Object)new Source(URI.create("http://www.apache.org////").toURL()));
        Assert.assertEquals((Object)new Source(URI.create("http://www.apache.org").toURL()), (Object)new Source(URI.create("http://www.apache.org/./././.").toURL()));
    }

    public void testEqualityURLHttps() throws MalformedURLException {
        Assert.assertEquals((Object)new Source(URI.create("https://www.apache.org/index.html").toURL()), (Object)new Source(URI.create("https://www.apache.org/index.html").toURL()));
        Assert.assertEquals((Object)new Source(URI.create("https://www.apache.org").toURL()), (Object)new Source(URI.create("https://www.apache.org////").toURL()));
        Assert.assertEquals((Object)new Source(URI.create("https://www.apache.org").toURL()), (Object)new Source(URI.create("https://www.apache.org/./././.").toURL()));
    }

    @Test
    public void testFileConstructor() {
        Path path = Paths.get("foo", new String[0]);
        URI uri = path.toUri();
        File file = path.toFile();
        Source source = new Source(file);
        Assert.assertEquals((Object)file, (Object)source.getFile());
        Assert.assertEquals((Object)path, (Object)source.getFile().toPath());
        Assert.assertEquals((Object)path, (Object)source.getPath());
        Assert.assertEquals((Object)uri, (Object)source.getURI());
    }

    @Test
    public void testPathStringConstructor() {
        Path path = Paths.get("foo", new String[0]);
        URI uri = path.toUri();
        File file = path.toFile();
        Source source = new Source(path);
        Assert.assertEquals((Object)file, (Object)source.getFile());
        Assert.assertEquals((Object)path, (Object)source.getFile().toPath());
        Assert.assertEquals((Object)path, (Object)source.getPath());
        Assert.assertEquals((Object)uri, (Object)source.getURI());
    }

    public void testPathURIFileConstructor() {
        Path path = Paths.get(URI.create("file:///C:/foo"));
        URI uri = path.toUri();
        File file = path.toFile();
        Source source = new Source(path);
        Assert.assertEquals((Object)file, (Object)source.getFile());
        Assert.assertEquals((Object)path, (Object)source.getFile().toPath());
        Assert.assertEquals((Object)path, (Object)source.getPath());
        Assert.assertEquals((Object)uri, (Object)source.getURI());
    }

    @Test
    public void testURIConstructor() throws MalformedURLException {
        Path path = Paths.get("foo", new String[0]);
        URI uri = path.toUri();
        File file = path.toFile();
        Source source = new Source(uri);
        Assert.assertEquals((Object)file.getAbsoluteFile(), (Object)source.getFile());
        Assert.assertEquals((Object)uri.toString(), (Object)source.getLocation());
        Assert.assertEquals((Object)path.toAbsolutePath(), (Object)source.getPath());
    }

    @Test
    public void testURIFileConstructor() throws MalformedURLException {
        URI uri = URI.create("file:///C:/foo");
        Path path = Paths.get(uri);
        File file = path.toFile();
        Source source = new Source(uri);
        Assert.assertEquals((Object)file.getAbsoluteFile(), (Object)source.getFile());
        Assert.assertEquals((Object)uri.toString(), (Object)source.getLocation());
    }

    @Test
    public void testURIHttpConstructor() throws MalformedURLException {
        URI uri = URI.create("http://www.apache.org");
        Source source = new Source(uri);
        Assert.assertEquals(null, (Object)source.getFile());
        Assert.assertEquals((Object)uri.toString(), (Object)source.getLocation());
    }

    @Test
    public void testURIHttpsConstructor() throws MalformedURLException {
        URI uri = URI.create("https://www.apache.org");
        Source source = new Source(uri);
        Assert.assertEquals(null, (Object)source.getFile());
        Assert.assertEquals((Object)uri.toString(), (Object)source.getLocation());
    }

    @Test
    public void testURLConstructor() throws MalformedURLException {
        Path path = Paths.get("foo", new String[0]);
        File file = path.toFile();
        URI uri = path.toUri();
        URL url = uri.toURL();
        Source source = new Source(url);
        Assert.assertEquals((Object)file.getAbsoluteFile(), (Object)source.getFile());
        Assert.assertEquals((Object)url.toString(), (Object)source.getLocation());
        Assert.assertEquals((Object)path.toAbsolutePath(), (Object)source.getPath());
    }
}

