/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.apache.logging.log4j.util.Strings;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@LoggerContextSource(value="log4j2-console-disableAnsi.xml")
public class DisableAnsiTest {
    private static final String EXPECTED = "ERROR LoggerTest o.a.l.l.c.p.DisableAnsiTest org.apache.logging.log4j.core.pattern.DisableAnsiTest" + Strings.LINE_SEPARATOR;
    private Logger logger;
    private ListAppender app;

    @BeforeEach
    public void setUp(LoggerContext context, @Named(value="List") ListAppender app) {
        this.logger = context.getLogger("LoggerTest");
        this.app = app.clear();
    }

    @Test
    public void testReplacement() {
        this.logger.error(this.getClass().getName());
        List<String> msgs = this.app.getMessages();
        Assertions.assertNotNull(msgs);
        Assertions.assertEquals((int)1, (int)msgs.size(), (String)("Incorrect number of messages. Should be 1 is " + msgs.size()));
        Assertions.assertTrue((boolean)msgs.get(0).endsWith(EXPECTED), (String)("Replacement failed - expected ending " + EXPECTED + ", actual " + msgs.get(0)));
    }
}

