/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.ssl;

import java.util.Properties;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.core.net.ssl.SslConfigurationFactory;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SslConfigurationFactoryTest {
    private static void addKeystoreConfiguration(Properties props) {
        props.setProperty("log4j2.keyStoreLocation", "org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks");
        props.setProperty("log4j2.keyStoreKeyStoreType", "JKS");
    }

    private static void addTruststoreConfiguration(Properties props) {
        props.setProperty("log4j2.trustStoreLocation", "org/apache/logging/log4j/core/net/ssl/truststore.jks");
        props.setProperty("log4j2.trustStoreKeyStoreType", "JKS");
    }

    @Test
    public void testStaticConfiguration() {
        Properties props = new Properties();
        PropertiesUtil util = new PropertiesUtil(props);
        SslConfiguration sslConfiguration = SslConfigurationFactory.createSslConfiguration((PropertiesUtil)util);
        Assertions.assertNull((Object)sslConfiguration);
        props.clear();
        SslConfigurationFactoryTest.addKeystoreConfiguration(props);
        util.reload();
        sslConfiguration = SslConfigurationFactory.createSslConfiguration((PropertiesUtil)util);
        Assertions.assertNotNull((Object)sslConfiguration);
        Assertions.assertNotNull((Object)sslConfiguration.getKeyStoreConfig());
        Assertions.assertNull((Object)sslConfiguration.getTrustStoreConfig());
        props.clear();
        SslConfigurationFactoryTest.addTruststoreConfiguration(props);
        util.reload();
        sslConfiguration = SslConfigurationFactory.createSslConfiguration((PropertiesUtil)util);
        Assertions.assertNotNull((Object)sslConfiguration);
        Assertions.assertNull((Object)sslConfiguration.getKeyStoreConfig());
        Assertions.assertNotNull((Object)sslConfiguration.getTrustStoreConfig());
        props.clear();
        SslConfigurationFactoryTest.addKeystoreConfiguration(props);
        SslConfigurationFactoryTest.addTruststoreConfiguration(props);
        util.reload();
        sslConfiguration = SslConfigurationFactory.createSslConfiguration((PropertiesUtil)util);
        Assertions.assertNotNull((Object)sslConfiguration);
        Assertions.assertNotNull((Object)sslConfiguration.getKeyStoreConfig());
        Assertions.assertNotNull((Object)sslConfiguration.getTrustStoreConfig());
    }
}

