/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import java.util.Collection;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.filter.StructuredDataFilter;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.apache.logging.log4j.util.IndexedReadOnlyStringMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StructuredDataFilterTest {
    @Test
    public void testFilter() {
        KeyValuePair[] pairs = new KeyValuePair[]{new KeyValuePair("id.name", "AccountTransfer"), new KeyValuePair("ToAccount", "123456")};
        StructuredDataFilter filter = StructuredDataFilter.createFilter((KeyValuePair[])pairs, (String)"and", null, null);
        Assertions.assertNotNull((Object)filter);
        filter.start();
        StructuredDataMessage msg = new StructuredDataMessage("AccountTransfer@18060", "Transfer Successful", "Audit");
        msg.put("ToAccount", "123456");
        msg.put("FromAccount", "211000");
        msg.put("Amount", "1000.00");
        Assertions.assertTrue((boolean)filter.isStarted());
        Assertions.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, Level.DEBUG, null, (Message)msg, null));
        msg.put("ToAccount", "111111");
        Assertions.assertSame((Object)Filter.Result.DENY, (Object)filter.filter(null, Level.ERROR, null, (Message)msg, null));
        filter = StructuredDataFilter.createFilter((KeyValuePair[])pairs, (String)"or", null, null);
        Assertions.assertNotNull((Object)filter);
        filter.start();
        msg = new StructuredDataMessage("AccountTransfer@18060", "Transfer Successful", "Audit");
        msg.put("ToAccount", "123456");
        msg.put("FromAccount", "211000");
        msg.put("Amount", "1000.00");
        Assertions.assertTrue((boolean)filter.isStarted());
        Assertions.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, Level.DEBUG, null, (Message)msg, null));
        msg.put("ToAccount", "111111");
        Assertions.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, Level.ERROR, null, (Message)msg, null));
    }

    @Test
    @LoggerContextSource(value="log4j2-sdfilter.xml")
    public void testConfig(Configuration config) {
        Filter filter = config.getFilter();
        Assertions.assertNotNull((Object)filter, (String)"No StructuredDataFilter");
        Assertions.assertTrue((boolean)(filter instanceof StructuredDataFilter), (String)"Not a StructuredDataFilter");
        StructuredDataFilter sdFilter = (StructuredDataFilter)filter;
        Assertions.assertFalse((boolean)sdFilter.isAnd(), (String)"Should not be And filter");
        IndexedReadOnlyStringMap map = sdFilter.getStringMap();
        Assertions.assertNotNull((Object)map, (String)"No Map");
        Assertions.assertFalse((boolean)map.isEmpty(), (String)"No elements in Map");
        Assertions.assertEquals((int)1, (int)map.size(), (String)"Incorrect number of elements in Map");
        Assertions.assertTrue((boolean)map.containsKey("eventId"), (String)"Map does not contain key eventId");
        Assertions.assertEquals((int)2, (int)((Collection)map.getValue("eventId")).size(), (String)"List does not contain 2 elements");
    }
}

