/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.validation.validators;

import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.NullConfiguration;
import org.apache.logging.log4j.core.config.plugins.util.PluginBuilder;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.config.plugins.validation.ValidatingPluginWithGenericBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ValidatingPluginWithGenericBuilderTest {
    private PluginType<ValidatingPluginWithGenericBuilder> plugin;
    private Node node;

    @BeforeEach
    public void setUp() throws Exception {
        PluginManager manager = new PluginManager("Test");
        manager.collectPlugins();
        this.plugin = manager.getPluginType("ValidatingPluginWithGenericBuilder");
        Assertions.assertNotNull(this.plugin, (String)"Rebuild this module to make sure annotation processing kicks in.");
        this.node = new Node(null, "Validator", this.plugin);
    }

    @Test
    public void testNullDefaultValue() throws Exception {
        ValidatingPluginWithGenericBuilder validatingPlugin = (ValidatingPluginWithGenericBuilder)new PluginBuilder(this.plugin).withConfiguration((Configuration)new NullConfiguration()).withConfigurationNode(this.node).build();
        Assertions.assertNull((Object)validatingPlugin);
    }

    @Test
    public void testNonNullValue() throws Exception {
        this.node.getAttributes().put("name", "foo");
        ValidatingPluginWithGenericBuilder validatingPlugin = (ValidatingPluginWithGenericBuilder)new PluginBuilder(this.plugin).withConfiguration((Configuration)new NullConfiguration()).withConfigurationNode(this.node).build();
        Assertions.assertNotNull((Object)validatingPlugin);
        Assertions.assertEquals((Object)"foo", (Object)validatingPlugin.getName());
    }
}

