/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.logging.log4j.core.appender.SocketAppender;
import org.apache.logging.log4j.core.appender.SocketAppenderTest;
import org.apache.logging.log4j.core.net.Rfc1349TrafficClass;
import org.apache.logging.log4j.core.net.SocketOptions;
import org.apache.logging.log4j.core.net.TcpSocketManager;
import org.apache.logging.log4j.core.net.ssl.KeyStoreConfiguration;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.core.net.ssl.StoreConfigurationException;
import org.apache.logging.log4j.core.net.ssl.TestConstants;
import org.apache.logging.log4j.core.net.ssl.TrustStoreConfiguration;
import org.apache.logging.log4j.core.util.NullOutputStream;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.AvailablePortFinder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.ClassRule;
import org.junit.Test;

public class SecureSocketAppenderSocketOptionsTest {
    private static final int PORT = AvailablePortFinder.getNextAvailable();
    private static SocketAppenderTest.TcpSocketTestServer tcpSocketTestServer;
    private static SSLServerSocketFactory serverSocketFactory;
    private static SslConfiguration sslConfiguration;
    @ClassRule
    public static final LoggerContextRule loggerContextRule;

    @AfterClass
    public static void afterClass() {
        if (tcpSocketTestServer != null) {
            tcpSocketTestServer.shutdown();
        }
    }

    public static void initServerSocketFactory() throws StoreConfigurationException {
        KeyStoreConfiguration ksc = KeyStoreConfiguration.createKeyStoreConfiguration((String)"src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks", (char[])TestConstants.KEYSTORE_PWD(), null, null, null, null);
        TrustStoreConfiguration tsc = TrustStoreConfiguration.createKeyStoreConfiguration((String)"src/test/resources/org/apache/logging/log4j/core/net/ssl/truststore.jks", (char[])TestConstants.TRUSTSTORE_PWD(), null, null, null, null);
        sslConfiguration = SslConfiguration.createSSLConfiguration(null, (KeyStoreConfiguration)ksc, (TrustStoreConfiguration)tsc);
        serverSocketFactory = sslConfiguration.getSslServerSocketFactory();
    }

    @Test
    public void testSocketOptions() throws IOException {
        Assert.assertNotNull((Object)loggerContextRule);
        Assert.assertNotNull((Object)loggerContextRule.getConfiguration());
        SocketAppender appender = loggerContextRule.getAppender("socket", SocketAppender.class);
        Assert.assertNotNull((Object)appender);
        TcpSocketManager manager = (TcpSocketManager)appender.getManager();
        Assert.assertNotNull((Object)manager);
        OutputStream outputStream = manager.getOutputStream();
        Assert.assertFalse((boolean)(outputStream instanceof NullOutputStream));
        SocketOptions socketOptions = manager.getSocketOptions();
        Assert.assertNotNull((Object)socketOptions);
        Socket socket = manager.getSocket();
        Assert.assertNotNull((Object)socket);
        Assert.assertEquals((Object)false, (Object)socketOptions.isKeepAlive());
        Assert.assertEquals(null, (Object)socketOptions.isOobInline());
        Assert.assertEquals((Object)false, (Object)socketOptions.isReuseAddress());
        Assert.assertEquals((Object)false, (Object)socketOptions.isTcpNoDelay());
        Assert.assertEquals((long)Rfc1349TrafficClass.IPTOS_LOWCOST.value(), (long)socketOptions.getActualTrafficClass().intValue());
        Assert.assertEquals((long)10000L, (long)socketOptions.getReceiveBufferSize().intValue());
        Assert.assertEquals((long)8000L, (long)socketOptions.getSendBufferSize().intValue());
        Assert.assertEquals((long)12345L, (long)socketOptions.getSoLinger().intValue());
        Assert.assertEquals((long)54321L, (long)socketOptions.getSoTimeout().intValue());
        Assert.assertEquals((Object)false, (Object)socket.getKeepAlive());
        Assert.assertEquals((Object)false, (Object)socket.getReuseAddress());
        Assert.assertEquals((Object)false, (Object)socket.getTcpNoDelay());
        Assert.assertEquals((long)12345L, (long)socket.getSoLinger());
        Assert.assertEquals((long)54321L, (long)socket.getSoTimeout());
    }

    @Test
    public void testSocketTrafficClass() throws IOException {
        Assume.assumeTrue((String)"Run only on Java 7", (boolean)System.getProperty("java.specification.version").equals("1.7"));
        Assume.assumeFalse((String)"Do not run on Travis CI", (boolean)"true".equals(System.getenv("TRAVIS")));
        SocketAppender appender = loggerContextRule.getAppender("socket", SocketAppender.class);
        TcpSocketManager manager = (TcpSocketManager)appender.getManager();
        Socket socket = manager.getSocket();
        Assert.assertEquals((long)Rfc1349TrafficClass.IPTOS_LOWCOST.value(), (long)socket.getTrafficClass());
    }

    static {
        System.setProperty("SecureSocketAppenderSocketOptionsTest.port", Integer.toString(PORT));
        try {
            SecureSocketAppenderSocketOptionsTest.initServerSocketFactory();
            tcpSocketTestServer = new SocketAppenderTest.TcpSocketTestServer(serverSocketFactory.createServerSocket(PORT));
            tcpSocketTestServer.start();
            loggerContextRule = new LoggerContextRule("log4j-ssl-socket-options.xml");
        }
        catch (IOException | StoreConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }
}

