/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.test.appender.FailOnceAppender;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@LoggerContextSource(value="log4j-failover.xml")
public class FailoverAppenderTest {
    private final ListAppender app;
    private final FailOnceAppender foApp;
    private final Logger logger;
    private final Logger onceLogger;

    public FailoverAppenderTest(LoggerContext context, @Named(value="List") ListAppender app, @Named(value="Once") FailOnceAppender foApp) {
        this.app = app;
        this.foApp = foApp;
        this.logger = context.getLogger("LoggerTest");
        this.onceLogger = context.getLogger("Once");
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.app.clear();
    }

    @Test
    public void testFailover() {
        this.logger.error("This is a test");
        List<LogEvent> events = this.app.getEvents();
        Assertions.assertNotNull(events);
        Assertions.assertEquals((int)events.size(), (int)1, (String)("Incorrect number of events. Should be 1 is " + events.size()));
        this.app.clear();
        this.logger.error("This is a test");
        events = this.app.getEvents();
        Assertions.assertNotNull(events);
        Assertions.assertEquals((int)events.size(), (int)1, (String)("Incorrect number of events. Should be 1 is " + events.size()));
    }

    @Test
    public void testRecovery() throws Exception {
        this.onceLogger.error("Fail once");
        this.onceLogger.error("Fail again");
        List<LogEvent> events = this.app.getEvents();
        Assertions.assertNotNull(events);
        Assertions.assertEquals((int)events.size(), (int)2, (String)("Incorrect number of events. Should be 2 is " + events.size()));
        this.app.clear();
        Thread.sleep(1100L);
        this.onceLogger.error("Fail after recovery interval");
        this.onceLogger.error("Second log message");
        events = this.app.getEvents();
        Assertions.assertEquals((int)events.size(), (int)0, (String)"Did not recover");
        events = this.foApp.drainEvents();
        Assertions.assertEquals((int)events.size(), (int)2, (String)"Incorrect number of events in primary appender");
    }
}

