/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.util.Base64;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.net.UrlConnectionFactory;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class UrlConnectionFactoryTest {
    private static final Logger LOGGER = LogManager.getLogger(UrlConnectionFactoryTest.class);
    private static final String BASIC = "Basic ";
    private static final String expectedCreds = "testuser:password";
    private static Server server;
    private static Base64.Decoder decoder;
    private static int port;
    private static final int NOT_MODIFIED = 304;
    private static final int NOT_AUTHORIZED = 401;
    private static final int OK = 200;
    private static final int BUF_SIZE = 1024;

    @BeforeAll
    public static void startServer() throws Exception {
        try {
            server = new Server(0);
            ServletContextHandler context = new ServletContextHandler();
            ServletHolder defaultServ = new ServletHolder("default", TestServlet.class);
            defaultServ.setInitParameter("resourceBase", System.getProperty("user.dir"));
            defaultServ.setInitParameter("dirAllowed", "true");
            context.addServlet(defaultServ, "/");
            server.setHandler((Handler)context);
            server.start();
            port = ((ServerConnector)server.getConnectors()[0]).getLocalPort();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    @AfterAll
    public static void stopServer() throws Exception {
        server.stop();
    }

    @Test
    public void testBadCrdentials() throws Exception {
        System.setProperty("log4j2.Configuration.username", "foo");
        System.setProperty("log4j2.Configuration.password", "bar");
        System.setProperty("log4j2.Configuration.allowedProtocols", "http");
        URI uri = new URI("http://localhost:" + port + "/log4j2-config.xml");
        ConfigurationSource source = ConfigurationSource.fromUri((URI)uri);
        Assertions.assertNull((Object)source, (String)"A ConfigurationSource should not have been returned");
    }

    @Test
    public void withAuthentication() throws Exception {
        System.setProperty("log4j2.Configuration.username", "testuser");
        System.setProperty("log4j2.Configuration.password", "password");
        System.setProperty("log4j2.Configuration.allowedProtocols", "http");
        URI uri = new URI("http://localhost:" + port + "/log4j2-config.xml");
        ConfigurationSource source = ConfigurationSource.fromUri((URI)uri);
        Assertions.assertNotNull((Object)source, (String)"No ConfigurationSource returned");
        InputStream is = source.getInputStream();
        Assertions.assertNotNull((Object)is, (String)"No data returned");
        long lastModified = source.getLastModified();
        int result = this.verifyNotModified(uri, lastModified);
        Assertions.assertEquals((int)304, (int)result, (String)"File was modified");
        File file = new File("target/test-classes/log4j2-config.xml");
        if (!file.setLastModified(System.currentTimeMillis())) {
            Assertions.fail((String)"Unable to set last modified time");
        }
        result = this.verifyNotModified(uri, lastModified);
        Assertions.assertEquals((int)200, (int)result, (String)"File was not modified");
    }

    private int verifyNotModified(URI uri, long lastModifiedMillis) throws Exception {
        HttpURLConnection urlConnection = UrlConnectionFactory.createConnection((URL)uri.toURL(), (long)lastModifiedMillis, null);
        urlConnection.connect();
        try {
            return urlConnection.getResponseCode();
        }
        catch (IOException ioe) {
            LOGGER.error("Error accessing configuration at {}: {}", (Object)uri, (Object)ioe.getMessage());
            return 500;
        }
    }

    static {
        decoder = Base64.getDecoder();
    }

    public static class TestServlet
    extends DefaultServlet {
        private static final long serialVersionUID = -2885158530511450659L;

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            Enumeration headers = request.getHeaders(HttpHeader.AUTHORIZATION.toString());
            if (headers == null) {
                response.sendError(401, "No Auth header");
                return;
            }
            while (headers.hasMoreElements()) {
                String authData = (String)headers.nextElement();
                Assertions.assertTrue((boolean)authData.startsWith(UrlConnectionFactoryTest.BASIC), (String)"Not a Basic auth header");
                String credentials = new String(decoder.decode(authData.substring(UrlConnectionFactoryTest.BASIC.length())));
                if (UrlConnectionFactoryTest.expectedCreds.equals(credentials)) continue;
                response.sendError(401, "Invalid credentials");
                return;
            }
            if (request.getServletPath().equals("/log4j2-config.xml")) {
                File file = new File("target/test-classes/log4j2-config.xml");
                long modifiedSince = request.getDateHeader(HttpHeader.IF_MODIFIED_SINCE.toString());
                long lastModified = file.lastModified() / 1000L * 1000L;
                LOGGER.debug("LastModified: {}, modifiedSince: {}", (Object)lastModified, (Object)modifiedSince);
                if (modifiedSince > 0L && lastModified <= modifiedSince) {
                    response.setStatus(304);
                    return;
                }
                response.setDateHeader(HttpHeader.LAST_MODIFIED.toString(), lastModified);
                response.setContentLengthLong(file.length());
                Files.copy(file.toPath(), (OutputStream)response.getOutputStream());
                response.getOutputStream().flush();
                response.setStatus(200);
            } else {
                response.sendError(400, "Unsupported request");
            }
        }
    }
}

