/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.lookup.DateLookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.NullSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

public class DateLookupTest {
    @Test
    public void testCorrectEvent() {
        LogEvent mockedEvent = (LogEvent)Mockito.mock(LogEvent.class);
        Calendar cal = Calendar.getInstance();
        cal.set(2011, 11, 30, 10, 56, 35);
        Mockito.when((Object)mockedEvent.getTimeMillis()).thenReturn((Object)cal.getTimeInMillis());
        String lookupDate = new DateLookup().lookup(mockedEvent, "MM/dd/yyyy");
        Assertions.assertEquals((Object)"12/30/2011", (Object)lookupDate);
    }

    @Test
    public void testValidKeyWithoutEvent() {
        String dateFormat = "MM/dd/yyyy";
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
        cal.setTimeInMillis(System.currentTimeMillis());
        String today = formatter.format(cal.getTime());
        cal.add(5, 1);
        String tomorrow = formatter.format(cal.getTime());
        String lookupTime = new DateLookup().lookup(null, "MM/dd/yyyy");
        Assertions.assertTrue((lookupTime.equals(today) || lookupTime.equals(tomorrow) ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @NullSource
    @ValueSource(strings={"bananas"})
    public void testInvalidKey(String key) {
        Assertions.assertNotNull((Object)new DateLookup().lookup(null, key));
    }
}

