/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.util.List;
import org.apache.logging.log4j.categories.Layouts;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Layouts.Json.class})
public class JsonLayoutMillisTest {
    private static final String CONFIG = "log4j2-json-layout-timestamp.xml";
    private ListAppender app;
    @Rule
    public LoggerContextRule context = new LoggerContextRule("log4j2-json-layout-timestamp.xml");
    private Logger logger;

    private void assertEventCount(List<LogEvent> events, int expected) {
        Assert.assertEquals((String)"Incorrect number of events.", (long)expected, (long)events.size());
    }

    @Before
    public void before() {
        this.logger = this.context.getLogger("LayoutTest");
        this.app = this.context.getListAppender("List").clear();
    }

    @Test
    public void testTimestamp() {
        this.logger.info("This is a test message");
        List<String> message = this.app.getMessages();
        Assert.assertTrue((String)"No messages", (message != null && message.size() > 0 ? 1 : 0) != 0);
        String json = message.get(0);
        System.out.println(json);
        Assert.assertNotNull((String)"No JSON message", (Object)json);
        Assert.assertTrue((String)"No timestamp", (boolean)json.contains("\"timeMillis\":"));
        Assert.assertFalse((String)"Instant is present", (boolean)json.contains("instant:"));
    }
}

