/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.io.File;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;

@LoggerContextSource(value="reconfiguration-deadlock.xml")
public class ReconfigurationDeadlockTest {
    private static final int WORKER_COUNT = 100;
    private ExecutorService executor;

    @BeforeEach
    public void startExecutor() {
        this.executor = Executors.newFixedThreadPool(100);
    }

    @AfterEach
    public void stopExecutor() throws InterruptedException {
        this.executor.shutdownNow();
        boolean terminated = this.executor.awaitTermination(30L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)terminated, (String)"couldn't terminate the executor");
    }

    @RepeatedTest(value=100)
    public void reconfiguration_should_not_cause_deadlock_for_ongoing_logging() throws Exception {
        ReconfigurationDeadlockTest.updateConfigFileModTime();
        CountDownLatch workerStartLatch = new CountDownLatch(100);
        List<Future<?>> workerFutures = ReconfigurationDeadlockTest.initiateWorkers(workerStartLatch, this.executor);
        workerStartLatch.await(10L, TimeUnit.SECONDS);
        ReconfigurationDeadlockTest.updateConfigFileModTime();
        for (int workerIndex = 0; workerIndex < 100; ++workerIndex) {
            Future<?> workerFuture = workerFutures.get(workerIndex);
            try {
                Object workerResult = workerFuture.get(30L, TimeUnit.SECONDS);
                Assertions.assertNull(workerResult);
                continue;
            }
            catch (Throwable failure) {
                String message = String.format("check for worker %02d/%02d has failed", workerIndex + 1, 100);
                throw new AssertionError(message, failure);
            }
        }
    }

    private static void updateConfigFileModTime() {
        File file = new File("target/test-classes/reconfiguration-deadlock.xml");
        boolean fileModified = file.setLastModified(System.currentTimeMillis());
        Assertions.assertTrue((boolean)fileModified, (String)"couldn't update file modification time");
    }

    private static List<Future<?>> initiateWorkers(CountDownLatch workerStartLatch, ExecutorService executor) {
        Logger logger = LogManager.getRootLogger();
        return IntStream.range(0, 100).mapToObj(workerIndex -> executor.submit(() -> {
            int i;
            for (i = 0; i < 1000; ++i) {
                logger.error("worker={}, iteration={}", (Object)workerIndex, (Object)i);
            }
            workerStartLatch.countDown();
            while (i < 5000) {
                logger.error("worker={}, iteration={}", (Object)workerIndex, (Object)i);
                ++i;
            }
        })).collect(Collectors.toList());
    }

    @Plugin(name="ReconfigurationDeadlockTestAppender", category="Core", elementType="appender", printObject=true)
    public static final class TestAppender
    extends AbstractAppender {
        private final Logger logger = LogManager.getRootLogger();

        private TestAppender(String name, Filter filter, Layout<?> layout, boolean ignoreExceptions) {
            super(name, filter, layout, ignoreExceptions, Property.EMPTY_ARRAY);
        }

        @PluginFactory
        public static TestAppender createAppender(@PluginAttribute(value="name") @Required(message="A name for the Appender must be specified") String name, @PluginAttribute(value="ignoreExceptions") boolean ignore, @PluginElement(value="Layout") Layout<?> layout, @PluginElement(value="Filter") Filter filter) {
            return new TestAppender(name, filter, layout, ignore);
        }

        public void append(LogEvent event) {
            boolean endOfBatch;
            int eventHashCode = event.hashCode();
            switch (Math.abs(eventHashCode % 4)) {
                case 0: {
                    endOfBatch = this.logger.isTraceEnabled();
                    break;
                }
                case 1: {
                    endOfBatch = this.logger.isDebugEnabled();
                    break;
                }
                case 2: {
                    endOfBatch = this.logger.isInfoEnabled();
                    break;
                }
                case 3: {
                    endOfBatch = this.logger.isWarnEnabled();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            event.setEndOfBatch(endOfBatch);
        }
    }
}

