/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class RollingAppenderDeleteScriptTest {
    private static final String CONFIG = "log4j-rolling-with-custom-delete-script.xml";
    private static final String DIR = "target/rolling-with-delete-script/test";
    private final LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("log4j-rolling-with-custom-delete-script.xml");
    @Rule
    public RuleChain chain = this.loggerContextRule.withCleanFoldersRule("target/rolling-with-delete-script/test");

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("log4j2.Script.enableLanguages", "Groovy, Javascript");
    }

    @Test
    public void testAppender() throws Exception {
        File[] files;
        Logger logger = this.loggerContextRule.getLogger();
        for (int i = 0; i < 10; ++i) {
            logger.debug("This is a test message number " + i);
        }
        Thread.sleep(100L);
        File dir = new File(DIR);
        Assert.assertTrue((String)"Dir target/rolling-with-delete-script/test should exist", (boolean)dir.exists());
        Assert.assertTrue((String)"Dir target/rolling-with-delete-script/test should contain files", (dir.listFiles().length > 0 ? 1 : 0) != 0);
        for (File file : files = dir.listFiles()) {
            System.out.println(file);
        }
        for (File file : files) {
            Assert.assertTrue((String)(file.getName() + " starts with 'test-'"), (boolean)file.getName().startsWith("test-"));
            Assert.assertTrue((String)(file.getName() + " ends with '.log'"), (boolean)file.getName().endsWith(".log"));
            String strIndex = file.getName().substring(5, file.getName().indexOf(46));
            int index = Integers.parseInt((String)strIndex);
            Assert.assertTrue((String)(file + " should have odd index"), (index % 2 == 1 ? 1 : 0) != 0);
        }
    }
}

