/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.junit.JdbcRule;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.h2.util.IOUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public abstract class AbstractJdbcAppenderFactoryMethodTest {
    @Rule
    public final RuleChain rules;
    private final JdbcRule jdbcRule;

    protected AbstractJdbcAppenderFactoryMethodTest(JdbcRule jdbcRule, String databaseType) {
        this.rules = RuleChain.emptyRuleChain().around((TestRule)jdbcRule).around((TestRule)new LoggerContextRule("org/apache/logging/log4j/core/appender/db/jdbc/log4j2-" + databaseType + "-factory-method.xml"));
        this.jdbcRule = jdbcRule;
    }

    @Test
    public void testFactoryMethodConfig() throws Exception {
        try (Connection connection = this.jdbcRule.getConnectionSource().getConnection();){
            SQLException exception = new SQLException("Some other error message!");
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try (PrintWriter writer = new PrintWriter(outputStream);){
                exception.printStackTrace(writer);
            }
            String stackTrace = outputStream.toString();
            long millis = System.currentTimeMillis();
            ThreadContext.put((String)"some_int", (String)"42");
            Logger logger = LogManager.getLogger((String)(this.getClass().getName() + ".testFactoryMethodConfig"));
            logger.debug("Factory logged message 01.");
            logger.error("Error from factory 02.", (Throwable)exception);
            try (Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT * FROM fmLogEntry ORDER BY id");){
                Assert.assertTrue((String)"There should be at least one row.", (boolean)resultSet.next());
                long date = resultSet.getTimestamp("eventDate").getTime();
                long anotherDate = resultSet.getTimestamp("anotherDate").getTime();
                Assert.assertEquals((long)date, (long)anotherDate);
                Assert.assertTrue((String)"The date should be later than pre-logging (1).", (date >= millis ? 1 : 0) != 0);
                Assert.assertTrue((String)"The date should be earlier than now (1).", (date <= System.currentTimeMillis() ? 1 : 0) != 0);
                Assert.assertEquals((String)"The literal column is not correct (1).", (Object)"Some Other Literal Value", (Object)resultSet.getString("literalColumn"));
                Assert.assertEquals((String)"The level column is not correct (1).", (Object)"DEBUG", (Object)resultSet.getNString("level"));
                Assert.assertEquals((String)"The logger column is not correct (1).", (Object)logger.getName(), (Object)resultSet.getNString("logger"));
                Assert.assertEquals((String)"The message column is not correct (1).", (Object)"Factory logged message 01.", (Object)resultSet.getString("message"));
                Assert.assertEquals((String)"The exception column is not correct (1).", (Object)"", (Object)IOUtils.readStringAndClose((Reader)resultSet.getNClob("exception").getCharacterStream(), (int)-1));
                Assert.assertTrue((String)"There should be two rows.", (boolean)resultSet.next());
                date = resultSet.getTimestamp("eventDate").getTime();
                anotherDate = resultSet.getTimestamp("anotherDate").getTime();
                Assert.assertEquals((long)date, (long)anotherDate);
                Assert.assertTrue((String)"The date should be later than pre-logging (2).", (date >= millis ? 1 : 0) != 0);
                Assert.assertTrue((String)"The date should be earlier than now (2).", (date <= System.currentTimeMillis() ? 1 : 0) != 0);
                Assert.assertEquals((String)"The literal column is not correct (2).", (Object)"Some Other Literal Value", (Object)resultSet.getString("literalColumn"));
                Assert.assertEquals((String)"The level column is not correct (2).", (Object)"ERROR", (Object)resultSet.getNString("level"));
                Assert.assertEquals((String)"The logger column is not correct (2).", (Object)logger.getName(), (Object)resultSet.getNString("logger"));
                Assert.assertEquals((String)"The message column is not correct (2).", (Object)"Error from factory 02.", (Object)resultSet.getString("message"));
                Assert.assertEquals((String)"The exception column is not correct (2).", (Object)stackTrace, (Object)IOUtils.readStringAndClose((Reader)resultSet.getNClob("exception").getCharacterStream(), (int)-1));
                Assert.assertFalse((String)"There should not be three rows.", (boolean)resultSet.next());
            }
        }
    }

    @Test
    public void testTruncate() {
        Logger logger = LogManager.getLogger((String)(this.getClass().getName() + ".testFactoryMethodConfig"));
        logger.debug(StringUtils.repeat((char)'A', (int)1000));
    }
}

