/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db;

import java.io.Serializable;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.db.AbstractDatabaseManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AbstractDatabaseManagerTest {
    private AbstractDatabaseManager manager;

    public void setUp(String name, int buffer) {
        this.manager = (AbstractDatabaseManager)Mockito.spy((Object)((Object)new StubDatabaseManager(name, buffer)));
    }

    @Test
    public void testBuffering01() throws Exception {
        this.setUp("name", 0);
        LogEvent event1 = (LogEvent)Mockito.mock(LogEvent.class);
        LogEvent event2 = (LogEvent)Mockito.mock(LogEvent.class);
        LogEvent event3 = (LogEvent)Mockito.mock(LogEvent.class);
        this.manager.startup();
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).startupInternal();
        Mockito.reset((Object[])new AbstractDatabaseManager[]{this.manager});
        this.manager.write(event1, null);
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).writeThrough((LogEvent)ArgumentMatchers.same((Object)event1), (Serializable)ArgumentMatchers.isNull());
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).connectAndStart();
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).isBuffered();
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).writeInternal((LogEvent)ArgumentMatchers.same((Object)event1), (Serializable)ArgumentMatchers.isNull());
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).commitAndClose();
        BDDMockito.then((Object)this.manager).shouldHaveNoMoreInteractions();
        Mockito.reset((Object[])new AbstractDatabaseManager[]{this.manager});
        this.manager.write(event2, null);
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).writeThrough((LogEvent)ArgumentMatchers.same((Object)event2), (Serializable)ArgumentMatchers.isNull());
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).connectAndStart();
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).isBuffered();
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).writeInternal((LogEvent)ArgumentMatchers.same((Object)event2), (Serializable)ArgumentMatchers.isNull());
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).commitAndClose();
        BDDMockito.then((Object)this.manager).shouldHaveNoMoreInteractions();
        Mockito.reset((Object[])new AbstractDatabaseManager[]{this.manager});
        this.manager.write(event3, null);
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).writeThrough((LogEvent)ArgumentMatchers.same((Object)event3), (Serializable)ArgumentMatchers.isNull());
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).connectAndStart();
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).isBuffered();
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).writeInternal((LogEvent)ArgumentMatchers.same((Object)event3), (Serializable)ArgumentMatchers.isNull());
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).commitAndClose();
        BDDMockito.then((Object)this.manager).shouldHaveNoMoreInteractions();
        Mockito.reset((Object[])new AbstractDatabaseManager[]{this.manager});
    }

    @Test
    public void testBuffering02() throws Exception {
        this.setUp("name", 4);
        LogEvent event1 = (LogEvent)Mockito.mock(LogEvent.class);
        LogEvent event2 = (LogEvent)Mockito.mock(LogEvent.class);
        LogEvent event3 = (LogEvent)Mockito.mock(LogEvent.class);
        LogEvent event4 = (LogEvent)Mockito.mock(LogEvent.class);
        LogEvent event1copy = (LogEvent)Mockito.mock(LogEvent.class);
        LogEvent event2copy = (LogEvent)Mockito.mock(LogEvent.class);
        LogEvent event3copy = (LogEvent)Mockito.mock(LogEvent.class);
        LogEvent event4copy = (LogEvent)Mockito.mock(LogEvent.class);
        Mockito.when((Object)event1.toImmutable()).thenReturn((Object)event1copy);
        Mockito.when((Object)event2.toImmutable()).thenReturn((Object)event2copy);
        Mockito.when((Object)event3.toImmutable()).thenReturn((Object)event3copy);
        Mockito.when((Object)event4.toImmutable()).thenReturn((Object)event4copy);
        this.manager.startup();
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).startupInternal();
        this.manager.write(event1, null);
        this.manager.write(event2, null);
        this.manager.write(event3, null);
        this.manager.write(event4, null);
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).connectAndStart();
        ((AbstractDatabaseManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.times((int)5))).isBuffered();
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).writeInternal((LogEvent)ArgumentMatchers.same((Object)event1copy), (Serializable)ArgumentMatchers.isNull());
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).buffer(event1);
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).writeInternal((LogEvent)ArgumentMatchers.same((Object)event2copy), (Serializable)ArgumentMatchers.isNull());
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).buffer(event2);
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).writeInternal((LogEvent)ArgumentMatchers.same((Object)event3copy), (Serializable)ArgumentMatchers.isNull());
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).buffer(event3);
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).writeInternal((LogEvent)ArgumentMatchers.same((Object)event4copy), (Serializable)ArgumentMatchers.isNull());
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).buffer(event4);
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).commitAndClose();
        BDDMockito.then((Object)this.manager).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testBuffering03() throws Exception {
        this.setUp("name", 10);
        LogEvent event1 = (LogEvent)Mockito.mock(LogEvent.class);
        LogEvent event2 = (LogEvent)Mockito.mock(LogEvent.class);
        LogEvent event3 = (LogEvent)Mockito.mock(LogEvent.class);
        LogEvent event1copy = (LogEvent)Mockito.mock(LogEvent.class);
        LogEvent event2copy = (LogEvent)Mockito.mock(LogEvent.class);
        LogEvent event3copy = (LogEvent)Mockito.mock(LogEvent.class);
        Mockito.when((Object)event1.toImmutable()).thenReturn((Object)event1copy);
        Mockito.when((Object)event2.toImmutable()).thenReturn((Object)event2copy);
        Mockito.when((Object)event3.toImmutable()).thenReturn((Object)event3copy);
        this.manager.startup();
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).startupInternal();
        this.manager.write(event1, null);
        this.manager.write(event2, null);
        this.manager.write(event3, null);
        this.manager.flush();
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).connectAndStart();
        ((AbstractDatabaseManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.times((int)4))).isBuffered();
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).writeInternal((LogEvent)ArgumentMatchers.same((Object)event1copy), (Serializable)ArgumentMatchers.isNull());
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).buffer(event1);
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).writeInternal((LogEvent)ArgumentMatchers.same((Object)event2copy), (Serializable)ArgumentMatchers.isNull());
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).buffer(event2);
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).writeInternal((LogEvent)ArgumentMatchers.same((Object)event3copy), (Serializable)ArgumentMatchers.isNull());
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).buffer(event3);
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).commitAndClose();
        BDDMockito.then((Object)this.manager).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testBuffering04() throws Exception {
        this.setUp("name", 10);
        LogEvent event1 = (LogEvent)Mockito.mock(LogEvent.class);
        LogEvent event2 = (LogEvent)Mockito.mock(LogEvent.class);
        LogEvent event3 = (LogEvent)Mockito.mock(LogEvent.class);
        LogEvent event1copy = (LogEvent)Mockito.mock(LogEvent.class);
        LogEvent event2copy = (LogEvent)Mockito.mock(LogEvent.class);
        LogEvent event3copy = (LogEvent)Mockito.mock(LogEvent.class);
        Mockito.when((Object)event1.toImmutable()).thenReturn((Object)event1copy);
        Mockito.when((Object)event2.toImmutable()).thenReturn((Object)event2copy);
        Mockito.when((Object)event3.toImmutable()).thenReturn((Object)event3copy);
        this.manager.startup();
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).startupInternal();
        this.manager.write(event1, null);
        this.manager.write(event2, null);
        this.manager.write(event3, null);
        this.manager.shutdown();
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).connectAndStart();
        ((AbstractDatabaseManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.times((int)4))).isBuffered();
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).writeInternal((LogEvent)ArgumentMatchers.same((Object)event1copy), (Serializable)ArgumentMatchers.isNull());
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).buffer(event1);
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).writeInternal((LogEvent)ArgumentMatchers.same((Object)event2copy), (Serializable)ArgumentMatchers.isNull());
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).buffer(event2);
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).writeInternal((LogEvent)ArgumentMatchers.same((Object)event3copy), (Serializable)ArgumentMatchers.isNull());
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).buffer(event3);
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).commitAndClose();
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).shutdownInternal();
        BDDMockito.then((Object)this.manager).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testStartupShutdown01() throws Exception {
        this.setUp("testName01", 0);
        Assert.assertEquals((String)"The name is not correct.", (Object)"testName01", (Object)this.manager.getName());
        Assert.assertFalse((String)"The manager should not have started.", (boolean)this.manager.isRunning());
        this.manager.startup();
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).startupInternal();
        Assert.assertTrue((String)"The manager should be running now.", (boolean)this.manager.isRunning());
        this.manager.shutdown();
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).shutdownInternal();
        Assert.assertFalse((String)"The manager should not be running anymore.", (boolean)this.manager.isRunning());
    }

    @Test
    public void testStartupShutdown02() throws Exception {
        this.setUp("anotherName02", 0);
        Assert.assertEquals((String)"The name is not correct.", (Object)"anotherName02", (Object)this.manager.getName());
        Assert.assertFalse((String)"The manager should not have started.", (boolean)this.manager.isRunning());
        this.manager.startup();
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).startupInternal();
        Assert.assertTrue((String)"The manager should be running now.", (boolean)this.manager.isRunning());
        this.manager.releaseSub(-1L, null);
        ((AbstractDatabaseManager)BDDMockito.then((Object)this.manager).should()).shutdownInternal();
        Assert.assertFalse((String)"The manager should not be running anymore.", (boolean)this.manager.isRunning());
    }

    @Test
    public void testToString01() {
        this.setUp("someName01", 0);
        Assert.assertEquals((String)"The string is not correct.", (Object)"someName01", (Object)this.manager.toString());
    }

    @Test
    public void testToString02() {
        this.setUp("bufferSize=12, anotherKey02=coolValue02", 12);
        Assert.assertEquals((String)"The string is not correct.", (Object)"bufferSize=12, anotherKey02=coolValue02", (Object)this.manager.toString());
    }

    private static class StubDatabaseManager
    extends AbstractDatabaseManager {
        protected StubDatabaseManager(String name, int bufferSize) {
            super(name, bufferSize);
        }

        protected boolean commitAndClose() {
            return true;
        }

        protected void connectAndStart() {
        }

        protected boolean shutdownInternal() throws Exception {
            return true;
        }

        protected void startupInternal() throws Exception {
        }

        protected void writeInternal(LogEvent event, Serializable serializable) {
        }
    }
}

