/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.lookup.JavaLookup;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@LoggerContextSource(value="GelfLayout2Test.xml")
public class GelfLayout2Test {
    @Test
    public void gelfLayout(LoggerContext context, @Named ListAppender list) throws IOException {
        list.clear();
        ExtendedLogger logger = context.getLogger(this.getClass());
        logger.info("Message");
        String gelf = list.getMessages().get(0);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode json = mapper.readTree(gelf);
        Assertions.assertEquals((Object)"Message", (Object)json.get("short_message").asText());
        Assertions.assertEquals((Object)"myhost", (Object)json.get("host").asText());
        Assertions.assertEquals((Object)"FOO", (Object)json.get("_foo").asText());
        Assertions.assertEquals((Object)new JavaLookup().getRuntime(), (Object)json.get("_runtime").asText());
    }
}

