/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.validation;

import java.util.Objects;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;

@Plugin(name="Validator", category="Test")
public class ValidatingPlugin {
    private final String name;

    public ValidatingPlugin(String name) {
        this.name = Objects.requireNonNull(name, "name");
    }

    public String getName() {
        return this.name;
    }

    @PluginFactory
    public static ValidatingPlugin newValidatingPlugin(@Required(message="The name given by the factory is null") String name) {
        return new ValidatingPlugin(name);
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<ValidatingPlugin> {
        @PluginBuilderAttribute
        @Required(message="The name given by the builder is null")
        private String name;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public ValidatingPlugin build() {
            return new ValidatingPlugin(this.name);
        }
    }
}

