/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AsyncAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.test.appender.FailOnceAppender;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class AsyncAppenderExceptionHandlingTest {
    AsyncAppenderExceptionHandlingTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(strings={"RuntimeException", "LoggingException", "Exception", "Error", "Throwable", "ThreadDeath"})
    void AsyncAppender_should_not_stop_on_appender_failures(String throwableClassName) {
        String throwableClassNamePropertyName = "throwableClassName";
        System.setProperty("throwableClassName", throwableClassName);
        try (LoggerContext loggerContext = Configurator.initialize((String)"Test", (String)"AsyncAppenderExceptionHandlingTest.xml");){
            Logger logger = loggerContext.getRootLogger();
            logger.info("message #1");
            String lastLogMessage = "message #2";
            logger.info("message #2");
            Configuration configuration = loggerContext.getConfiguration();
            AsyncAppender asyncAppender = (AsyncAppender)configuration.getAppender("Async");
            Assertions.assertNotNull((Object)asyncAppender, (String)"couldn't obtain the FailOnceAppender");
            asyncAppender.stop();
            FailOnceAppender failOnceAppender = (FailOnceAppender)configuration.getAppender("FailOnce");
            Assertions.assertNotNull((Object)((Object)failOnceAppender), (String)"couldn't obtain the FailOnceAppender");
            Assertions.assertTrue((boolean)failOnceAppender.isFailed(), (String)"FailOnceAppender hasn't failed yet");
            List accumulatedMessages = failOnceAppender.drainEvents().stream().map(LogEvent::getMessage).map(Message::getFormattedMessage).collect(Collectors.toList());
            Assertions.assertEquals(Collections.singletonList("message #2"), accumulatedMessages);
        }
        finally {
            System.setProperty("throwableClassName", "");
        }
    }
}

