/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.db.jdbc.AbstractJdbcDataSourceTest;
import org.apache.logging.log4j.core.appender.db.jdbc.JdbcH2TestHelper;
import org.apache.logging.log4j.core.util.Throwables;
import org.apache.logging.log4j.junit.JdbcRule;
import org.apache.logging.log4j.junit.JndiRule;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.Message;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.BDDMockito;
import org.mockito.Mockito;

public class JdbcAppenderMapMessageDataSourceTest
extends AbstractJdbcDataSourceTest {
    @Rule
    public final RuleChain rules;
    private final JdbcRule jdbcRule;

    public JdbcAppenderMapMessageDataSourceTest() {
        this(new JdbcRule(JdbcH2TestHelper.TEST_CONFIGURATION_SOURCE_MEM, "CREATE TABLE dsLogEntry (Id INTEGER, ColumnA VARCHAR(255), ColumnB VARCHAR(255))", "DROP TABLE IF EXISTS dsLogEntry"));
    }

    protected JdbcAppenderMapMessageDataSourceTest(JdbcRule jdbcRule) {
        this.rules = RuleChain.emptyRuleChain().around((TestRule)new JndiRule("java:/comp/env/jdbc/TestDataSourceAppender", this.createMockDataSource())).around((TestRule)jdbcRule).around((TestRule)new LoggerContextRule("org/apache/logging/log4j/core/appender/db/jdbc/log4j2-data-source-map-message.xml"));
        this.jdbcRule = jdbcRule;
    }

    @Before
    public void afterEachDeleteDir() throws IOException {
        JdbcH2TestHelper.deleteDir();
    }

    @Before
    public void beforeEachDeleteDir() throws IOException {
        JdbcH2TestHelper.deleteDir();
    }

    private DataSource createMockDataSource() {
        try {
            DataSource dataSource = (DataSource)Mockito.mock(DataSource.class);
            BDDMockito.given((Object)dataSource.getConnection()).willAnswer(invocation -> this.jdbcRule.getConnectionSource().getConnection());
            return dataSource;
        }
        catch (SQLException e) {
            Throwables.rethrow((Throwable)e);
            throw new InternalError("unreachable");
        }
    }

    @Test
    public void testDataSourceConfig() throws Exception {
        try (Connection connection = this.jdbcRule.getConnectionSource().getConnection();){
            Error exception = new Error("Final error massage is fatal!");
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(outputStream);
            exception.printStackTrace(writer);
            writer.close();
            Logger logger = LogManager.getLogger((String)(this.getClass().getName() + ".testDataSourceConfig"));
            MapMessage mapMessage = new MapMessage();
            mapMessage.with("Id", 1);
            mapMessage.with("ColumnA", "ValueA");
            mapMessage.with("ColumnB", "ValueB");
            logger.info((Message)mapMessage);
            try (Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT Id, ColumnA, ColumnB FROM dsLogEntry ORDER BY Id");){
                Assert.assertTrue((String)"There should be at least one row.", (boolean)resultSet.next());
                Assert.assertEquals((long)1L, (long)resultSet.getInt("Id"));
                Assert.assertFalse((String)"There should not be two rows.", (boolean)resultSet.next());
            }
        }
    }

    @Test
    public void testTruncate() throws SQLException {
        try (Connection connection = this.jdbcRule.getConnectionSource().getConnection();){
            Logger logger = LogManager.getLogger((String)(this.getClass().getName() + ".testFactoryMethodConfig"));
            MapMessage mapMessage = new MapMessage();
            mapMessage.with("Id", 1);
            mapMessage.with("ColumnA", StringUtils.repeat((char)'A', (int)1000));
            mapMessage.with("ColumnB", StringUtils.repeat((char)'B', (int)1000));
            logger.info((Message)mapMessage);
            try (Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT Id, ColumnA, ColumnB FROM dsLogEntry ORDER BY Id");){
                Assert.assertTrue((String)"There should be at least one row.", (boolean)resultSet.next());
                Assert.assertEquals((long)1L, (long)resultSet.getInt("Id"));
                Assert.assertFalse((String)"There should not be two rows.", (boolean)resultSet.next());
            }
        }
    }
}

