/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.filter.CompositeFilter;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@LoggerContextSource(value="log4j-customLevelsWithFilters.xml")
public class CustomLevelsWithFiltersTest {
    private Level infom1Level;
    private Level infop1Level;

    @BeforeEach
    public void before() {
        this.infom1Level = Level.getLevel((String)"INFOM1");
        this.infop1Level = Level.getLevel((String)"INFOP1");
    }

    @Test
    public void testConfiguration(Configuration configuration, @Named(value="info") FileAppender appender) {
        Assertions.assertNotNull((Object)configuration);
        Assertions.assertNotNull((Object)appender);
        CompositeFilter compFilter = (CompositeFilter)appender.getFilter();
        Assertions.assertNotNull((Object)compFilter);
        Filter[] filters = compFilter.getFiltersArray();
        Assertions.assertNotNull((Object)filters);
        boolean foundLevel = false;
        for (Filter filter : filters) {
            ThresholdFilter tFilter = (ThresholdFilter)filter;
            if (!this.infom1Level.equals((Object)tFilter.getLevel())) continue;
            foundLevel = true;
            break;
        }
        Assertions.assertTrue((boolean)foundLevel, (String)("Level not found: " + this.infom1Level));
    }

    @Test
    public void testCustomLevelInts() {
        Assertions.assertEquals((int)399, (int)this.infom1Level.intLevel());
        Assertions.assertEquals((int)401, (int)this.infop1Level.intLevel());
    }

    @Test
    public void testCustomLevelPresence() {
        Assertions.assertNotNull((Object)this.infom1Level);
        Assertions.assertNotNull((Object)this.infop1Level);
    }
}

