/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.dumbster.smtp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.dumbster.smtp.SmtpResponse;
import org.apache.logging.dumbster.smtp.SmtpState;
import org.apache.logging.log4j.util.Strings;

public class SmtpMessage {
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>(10);
    private final StringBuffer body = new StringBuffer();

    public void store(SmtpResponse response, String params) {
        if (params != null) {
            if (SmtpState.DATA_HDR.equals(response.getNextState())) {
                int headerNameEnd = params.indexOf(58);
                if (headerNameEnd >= 0) {
                    String name = params.substring(0, headerNameEnd).trim();
                    String value = params.substring(headerNameEnd + 1).trim();
                    this.addHeader(name, value);
                }
            } else if (SmtpState.DATA_BODY == response.getNextState()) {
                this.body.append(params);
            }
        }
    }

    public Iterator<String> getHeaderNames() {
        Set<String> nameSet = this.headers.keySet();
        return nameSet.iterator();
    }

    public String[] getHeaderValues(String name) {
        List<String> values = this.headers.get(name);
        if (values == null) {
            return Strings.EMPTY_ARRAY;
        }
        return values.toArray(Strings.EMPTY_ARRAY);
    }

    public String getHeaderValue(String name) {
        List<String> values = this.headers.get(name);
        if (values == null) {
            return null;
        }
        Iterator<String> iterator = values.iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    public String getBody() {
        return this.body.toString();
    }

    private void addHeader(String name, String value) {
        List<String> valueList = this.headers.get(name);
        if (valueList == null) {
            valueList = new ArrayList<String>(1);
            this.headers.put(name, valueList);
        }
        valueList.add(value);
    }

    public String toString() {
        StringBuilder msg = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            String name = entry.getKey();
            List<String> values = entry.getValue();
            for (String value : values) {
                msg.append(name);
                msg.append(": ");
                msg.append(value);
                msg.append('\n');
            }
        }
        msg.append('\n');
        msg.append(this.body);
        msg.append('\n');
        return msg.toString();
    }
}

