/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.categories.Layouts;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.BasicConfigurationFactory;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.layout.AbstractCsvLayout;
import org.apache.logging.log4j.core.layout.CsvLogEventLayout;
import org.apache.logging.log4j.junit.ThreadContextRule;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Layouts.Csv.class})
public class CsvLogEventLayoutTest {
    static ConfigurationFactory cf = new BasicConfigurationFactory();
    @Rule
    public final ThreadContextRule threadContextRule = new ThreadContextRule();
    private final LoggerContext ctx = LoggerContext.getContext();
    private final Logger root = this.ctx.getRootLogger();

    @AfterClass
    public static void cleanupClass() {
        ConfigurationFactory.removeConfigurationFactory((ConfigurationFactory)cf);
    }

    @BeforeClass
    public static void setupClass() {
        ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)cf);
        LoggerContext ctx = LoggerContext.getContext();
        ctx.reconfigure();
    }

    @Test
    public void testCustomCharset() {
        CsvLogEventLayout layout = CsvLogEventLayout.createLayout(null, (String)"Excel", null, null, null, null, null, null, (Charset)StandardCharsets.UTF_16, null, null);
        Assert.assertEquals((Object)"text/csv; charset=UTF-16", (Object)layout.getContentType());
    }

    @Test
    public void testHeaderFooter() {
        String header = "# Header";
        String footer = "# Footer ";
        CsvLogEventLayout layout = CsvLogEventLayout.createLayout((Configuration)this.ctx.getConfiguration(), (String)"Excel", null, null, null, null, null, null, null, (String)"# Header", (String)"# Footer ");
        this.testLayout(CSVFormat.DEFAULT, (AbstractCsvLayout)layout, "# Header", "# Footer ");
    }

    @Test
    public void testDefaultCharset() {
        CsvLogEventLayout layout = CsvLogEventLayout.createDefaultLayout();
        Assert.assertEquals((Object)StandardCharsets.UTF_8, (Object)layout.getCharset());
    }

    @Test
    public void testDefaultContentType() {
        CsvLogEventLayout layout = CsvLogEventLayout.createDefaultLayout();
        Assert.assertEquals((Object)"text/csv; charset=UTF-8", (Object)layout.getContentType());
    }

    private void testLayout(CSVFormat format) {
        this.testLayout(format, (AbstractCsvLayout)CsvLogEventLayout.createLayout((CSVFormat)format), null, null);
    }

    private void testLayout(CSVFormat format, AbstractCsvLayout layout, String header, String footer) {
        Map appenders = this.root.getAppenders();
        for (Appender appender : appenders.values()) {
            this.root.removeAppender(appender);
        }
        ListAppender appender = new ListAppender("List", null, (Layout<? extends Serializable>)layout, true, false);
        appender.start();
        this.root.addAppender((Appender)appender);
        this.root.setLevel(Level.DEBUG);
        this.root.debug("one={}, two={}, three={}", (Object)1, (Object)2, (Object)3);
        this.root.info("Hello");
        appender.stop();
        List<String> list = appender.getMessages();
        boolean hasHeaderSerializer = layout.getHeaderSerializer() != null;
        boolean hasFooterSerializer = layout.getFooterSerializer() != null;
        int headerOffset = hasHeaderSerializer ? 1 : 0;
        String event0 = list.get(0 + headerOffset);
        String event1 = list.get(1 + headerOffset);
        char del = format.getDelimiter();
        Assert.assertTrue((String)event0, (boolean)event0.contains(del + "DEBUG" + del));
        String quote = del == ',' ? "\"" : "";
        Assert.assertTrue((String)event0, (boolean)event0.contains(del + quote + "one=1, two=2, three=3" + quote + del));
        Assert.assertTrue((String)event1, (boolean)event1.contains(del + "INFO" + del));
        if (hasHeaderSerializer && header == null) {
            Assert.fail();
        }
        if (!hasHeaderSerializer && header != null) {
            Assert.fail();
        }
        if (hasFooterSerializer && footer == null) {
            Assert.fail();
        }
        if (!hasFooterSerializer && footer != null) {
            Assert.fail();
        }
        if (hasHeaderSerializer) {
            Assert.assertEquals((String)list.toString(), (Object)header, (Object)list.get(0));
        }
        if (hasFooterSerializer) {
            Assert.assertEquals((String)list.toString(), (Object)footer, (Object)list.get(list.size() - 1));
        }
    }

    @Test
    public void testLayoutDefault() throws Exception {
        this.testLayout(CSVFormat.DEFAULT);
    }

    @Test
    public void testLayoutExcel() throws Exception {
        this.testLayout(CSVFormat.EXCEL);
    }

    @Test
    public void testLayoutMySQL() throws Exception {
        this.testLayout(CSVFormat.MYSQL);
    }

    @Test
    public void testLayoutRFC4180() throws Exception {
        this.testLayout(CSVFormat.RFC4180);
    }

    @Test
    public void testLayoutTab() throws Exception {
        this.testLayout(CSVFormat.TDF);
    }
}

