/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AbstractFilterTest {
    @Test
    public void testUnrolledBackwardsCompatible() {
        ConcreteFilter filter = new ConcreteFilter();
        Filter.Result expected = Filter.Result.DENY;
        this.verifyMethodsWithUnrolledVarargs(filter, Filter.Result.DENY);
        filter.testResult = Filter.Result.ACCEPT;
        this.verifyMethodsWithUnrolledVarargs(filter, Filter.Result.ACCEPT);
    }

    private void verifyMethodsWithUnrolledVarargs(ConcreteFilter filter, Filter.Result expected) {
        Logger logger = null;
        Level level = null;
        Marker marker = null;
        Assertions.assertEquals((Object)expected, (Object)filter.filter(logger, level, marker, "", 1));
        Assertions.assertEquals((Object)expected, (Object)filter.filter(logger, level, marker, "", 1, 2));
        Assertions.assertEquals((Object)expected, (Object)filter.filter(logger, level, marker, "", 1, 2, 3));
        Assertions.assertEquals((Object)expected, (Object)filter.filter(logger, level, marker, "", 1, 2, 3, 4));
        Assertions.assertEquals((Object)expected, (Object)filter.filter(logger, level, marker, "", 1, 2, 3, 4, 5));
        Assertions.assertEquals((Object)expected, (Object)filter.filter(logger, level, marker, "", 1, 2, 3, 4, 5, 6));
        Assertions.assertEquals((Object)expected, (Object)filter.filter(logger, level, marker, "", 1, 2, 3, 4, 5, 6, 7));
        Assertions.assertEquals((Object)expected, (Object)filter.filter(logger, level, marker, "", 1, 2, 3, 4, 5, 6, 7, 8));
        Assertions.assertEquals((Object)expected, (Object)filter.filter(logger, level, marker, "", 1, 2, 3, 4, 5, 6, 7, 8, 9));
        Assertions.assertEquals((Object)expected, (Object)filter.filter(logger, level, marker, "", 1, 2, 3, 4, 5, 6, 7, 8, 9, 10));
    }

    static class ConcreteFilter
    extends AbstractFilter {
        Filter.Result testResult = Filter.Result.DENY;

        ConcreteFilter() {
        }

        public Filter.Result filter(LogEvent event) {
            return this.testResult;
        }

        public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
            return this.testResult;
        }

        public Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
            return this.testResult;
        }

        public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
            return this.testResult;
        }
    }
}

