/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.hamcrest.Descriptors;
import org.apache.logging.log4j.hamcrest.FileMatchers;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class RollingAppenderTimeTest {
    private static final String CONFIG = "log4j-rolling2.xml";
    private static final String DIR = "target/rolling2";
    private final LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("log4j-rolling2.xml");
    @Rule
    public RuleChain chain = this.loggerContextRule.withCleanFoldersRule("target/rolling2");

    @Test
    public void testAppender() throws Exception {
        Logger logger = this.loggerContextRule.getLogger();
        logger.debug("This is test message number 1");
        Thread.sleep(1500L);
        for (int i = 0; i < 16; ++i) {
            logger.debug("This is test message number " + i + 1);
        }
        File dir = new File(DIR);
        Assert.assertTrue((String)"Directory not created", (dir.exists() && dir.listFiles().length > 0 ? 1 : 0) != 0);
        int MAX_TRIES = 20;
        Matcher hasGzippedFile = Matchers.hasItemInArray(Descriptors.that(FileMatchers.hasName(Descriptors.that(Matchers.endsWith((String)".gz")))));
        for (int i = 0; i < 20; ++i) {
            File[] files = dir.listFiles();
            if (hasGzippedFile.matches((Object)files)) {
                return;
            }
            logger.debug("Adding additional event " + i);
            Thread.sleep(100L);
        }
        Assert.fail((String)"No compressed files found");
    }
}

