/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RollingAppenderNoUnconditionalDeleteTest {
    private final File directory;
    private Logger logger;
    @Rule
    public LoggerContextRule loggerContextRule;

    @Parameterized.Parameters(name="{0} \u2192 {1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"log4j-rolling-with-custom-delete-unconditional1.xml", "target/rolling-unconditional-delete1/test"}, {"log4j-rolling-with-custom-delete-unconditional2.xml", "target/rolling-unconditional-delete2/test"}, {"log4j-rolling-with-custom-delete-unconditional3.xml", "target/rolling-unconditional-delete3/test"});
    }

    public RollingAppenderNoUnconditionalDeleteTest(String configFile, String dir) {
        this.directory = new File(dir);
        this.loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule(configFile);
        this.deleteDir();
        this.deleteDirParent();
    }

    @Before
    public void setUp() throws Exception {
        this.logger = this.loggerContextRule.getLogger();
    }

    @Test
    public void testAppender() throws Exception {
        int LINECOUNT = 18;
        for (int i = 0; i < 18; ++i) {
            this.logger.debug("This is a test message number " + i);
        }
        Thread.sleep(100L);
        Assert.assertTrue((String)("Dir " + this.directory + " should exist"), (boolean)this.directory.exists());
        Assert.assertTrue((String)("Dir " + this.directory + " should contain files"), (this.directory.listFiles().length > 0 ? 1 : 0) != 0);
        int total = 0;
        for (File file : this.directory.listFiles()) {
            List<String> lines = Files.readAllLines(file.toPath(), Charset.defaultCharset());
            total += lines.size();
        }
        Assert.assertEquals((String)"rolled over lines", (long)17L, (long)total);
    }

    private void deleteDir() {
        this.deleteDir(this.directory);
    }

    private void deleteDirParent() {
        this.deleteDir(this.directory.getParentFile());
    }

    private void deleteDir(File dir) {
        if (dir.exists()) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                file.delete();
            }
            dir.delete();
        }
    }
}

