/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.jdbc;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="PoolableConnectionFactory", category="Core", printObject=true)
public class PoolableConnectionFactoryConfig {
    private final boolean cacheState;
    private final Collection<String> connectionInitSqls;
    private final Boolean defaultAutoCommit;
    private final String defaultCatalog;
    private final Integer defaultQueryTimeoutSeconds;
    private final Boolean defaultReadOnly;
    private final int defaultTransactionIsolation;
    private final Collection<String> disconnectionSqlCodes;
    private final boolean autoCommitOnReturn;
    private final boolean fastFailValidation;
    private final long maxConnLifetimeMillis;
    private final int maxOpenPreparedStatements;
    private final boolean poolStatements;
    private final boolean rollbackOnReturn;
    private final String validationQuery;
    private final int validationQueryTimeoutSeconds;

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    private PoolableConnectionFactoryConfig(boolean cacheState, Collection<String> connectionInitSqls, Boolean defaultAutoCommit, String defaultCatalog, Integer defaultQueryTimeoutSeconds, Boolean defaultReadOnly, int defaultTransactionIsolation, Collection<String> disconnectionSqlCodes, boolean enableAutoCommitOnReturn, boolean fastFailValidation, long maxConnLifetimeMillis, int maxOpenPreparedStatements, boolean poolStatements, boolean rollbackOnReturn, String validationQuery, int validationQueryTimeoutSeconds) {
        this.cacheState = cacheState;
        this.connectionInitSqls = connectionInitSqls;
        this.defaultAutoCommit = defaultAutoCommit;
        this.defaultCatalog = Strings.trimToNull((String)defaultCatalog);
        this.defaultQueryTimeoutSeconds = defaultQueryTimeoutSeconds;
        this.defaultReadOnly = defaultReadOnly;
        this.defaultTransactionIsolation = defaultTransactionIsolation;
        this.disconnectionSqlCodes = disconnectionSqlCodes;
        this.autoCommitOnReturn = enableAutoCommitOnReturn;
        this.fastFailValidation = fastFailValidation;
        this.maxConnLifetimeMillis = maxConnLifetimeMillis;
        this.maxOpenPreparedStatements = maxOpenPreparedStatements;
        this.poolStatements = poolStatements;
        this.rollbackOnReturn = rollbackOnReturn;
        this.validationQuery = Strings.trimToNull((String)validationQuery);
        this.validationQueryTimeoutSeconds = validationQueryTimeoutSeconds;
    }

    public void init(PoolableConnectionFactory poolableConnectionFactory) {
        if (poolableConnectionFactory != null) {
            StatusLogger.getLogger().debug("Initializing PoolableConnectionFactory {} with {}", (Object)poolableConnectionFactory, (Object)this);
            poolableConnectionFactory.setCacheState(this.cacheState);
            poolableConnectionFactory.setConnectionInitSql(this.connectionInitSqls);
            poolableConnectionFactory.setDefaultAutoCommit(this.defaultAutoCommit);
            poolableConnectionFactory.setDefaultCatalog(this.defaultCatalog);
            poolableConnectionFactory.setDefaultQueryTimeout(this.defaultQueryTimeoutSeconds);
            poolableConnectionFactory.setDefaultReadOnly(this.defaultReadOnly);
            poolableConnectionFactory.setDefaultTransactionIsolation(this.defaultTransactionIsolation);
            poolableConnectionFactory.setDisconnectionSqlCodes(this.disconnectionSqlCodes);
            poolableConnectionFactory.setEnableAutoCommitOnReturn(this.autoCommitOnReturn);
            poolableConnectionFactory.setFastFailValidation(this.fastFailValidation);
            poolableConnectionFactory.setMaxConnLifetimeMillis(this.maxConnLifetimeMillis);
            poolableConnectionFactory.setMaxOpenPreparedStatements(this.maxOpenPreparedStatements);
            poolableConnectionFactory.setPoolStatements(this.poolStatements);
            poolableConnectionFactory.setRollbackOnReturn(this.rollbackOnReturn);
            poolableConnectionFactory.setValidationQuery(this.validationQuery);
            poolableConnectionFactory.setValidationQueryTimeout(this.validationQueryTimeoutSeconds);
        }
    }

    public String toString() {
        return String.format("PoolableConnectionFactoryConfig [cacheState=%s, connectionInitSqls=%s, defaultAutoCommit=%s, defaultCatalog=%s, defaultQueryTimeoutSeconds=%s, defaultReadOnly=%s, defaultTransactionIsolation=%s, disconnectionSqlCodes=%s, enableAutoCommitOnReturn=%s, fastFailValidation=%s, maxConnLifetimeMillis=%s, maxOpenPreparedStatements=%s, poolStatements=%s, rollbackOnReturn=%s, validationQuery=%s, validationQueryTimeoutSeconds=%s]", this.cacheState, this.connectionInitSqls, this.defaultAutoCommit, this.defaultCatalog, this.defaultQueryTimeoutSeconds, this.defaultReadOnly, this.defaultTransactionIsolation, this.disconnectionSqlCodes, this.autoCommitOnReturn, this.fastFailValidation, this.maxConnLifetimeMillis, this.maxOpenPreparedStatements, this.poolStatements, this.rollbackOnReturn, this.validationQuery, this.validationQueryTimeoutSeconds);
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<PoolableConnectionFactoryConfig> {
        private static final PoolableConnectionFactory DEFAULT = new PoolableConnectionFactory(null, null);
        private static final int UNKNOWN_TRANSACTION_ISOLATION = -1;
        @PluginBuilderAttribute
        private boolean cacheState;
        @PluginElement(value="ConnectionInitSqls")
        private String[] connectionInitSqls;
        @PluginBuilderAttribute
        private Boolean defaultAutoCommit;
        @PluginBuilderAttribute
        private String defaultCatalog;
        @PluginBuilderAttribute
        private Integer defaultQueryTimeoutSeconds = DEFAULT.getDefaultQueryTimeout();
        @PluginBuilderAttribute
        private Boolean defaultReadOnly;
        @PluginBuilderAttribute
        private int defaultTransactionIsolation = -1;
        @PluginElement(value="DisconnectionSqlCodes")
        private String[] disconnectionSqlCodes = (String[])(DEFAULT.getDisconnectionSqlCodes() == null ? null : DEFAULT.getDisconnectionSqlCodes().toArray());
        @PluginBuilderAttribute
        private boolean autoCommitOnReturn = DEFAULT.isEnableAutoCommitOnReturn();
        @PluginBuilderAttribute
        private boolean fastFailValidation = DEFAULT.isFastFailValidation();
        @PluginBuilderAttribute
        private long maxConnLifetimeMillis = -1L;
        @PluginBuilderAttribute
        private int maxOpenPreparedStatements = 8;
        @PluginBuilderAttribute
        private boolean poolStatements;
        @PluginBuilderAttribute
        private boolean rollbackOnReturn = DEFAULT.isRollbackOnReturn();
        @PluginBuilderAttribute
        private String validationQuery;
        @PluginBuilderAttribute
        private int validationQueryTimeoutSeconds = -1;

        private List<String> asList(String[] array) {
            return array == null ? null : Arrays.asList(array);
        }

        public PoolableConnectionFactoryConfig build() {
            return new PoolableConnectionFactoryConfig(this.cacheState, this.asList(this.connectionInitSqls), this.defaultAutoCommit, this.defaultCatalog, this.defaultQueryTimeoutSeconds, this.defaultReadOnly, this.defaultTransactionIsolation, this.asList(this.disconnectionSqlCodes), this.autoCommitOnReturn, this.fastFailValidation, this.maxConnLifetimeMillis, this.maxOpenPreparedStatements, this.poolStatements, this.rollbackOnReturn, this.validationQuery, this.validationQueryTimeoutSeconds);
        }

        public Builder setAutoCommitOnReturn(boolean autoCommitOnReturn) {
            this.autoCommitOnReturn = autoCommitOnReturn;
            return this;
        }

        public Builder setCacheState(boolean cacheState) {
            this.cacheState = cacheState;
            return this;
        }

        public Builder setConnectionInitSqls(String ... connectionInitSqls) {
            this.connectionInitSqls = connectionInitSqls;
            return this;
        }

        public Builder setDefaultAutoCommit(Boolean defaultAutoCommit) {
            this.defaultAutoCommit = defaultAutoCommit;
            return this;
        }

        public Builder setDefaultCatalog(String defaultCatalog) {
            this.defaultCatalog = defaultCatalog;
            return this;
        }

        public Builder setDefaultQueryTimeoutSeconds(Integer defaultQueryTimeoutSeconds) {
            this.defaultQueryTimeoutSeconds = defaultQueryTimeoutSeconds;
            return this;
        }

        public Builder setDefaultReadOnly(Boolean defaultReadOnly) {
            this.defaultReadOnly = defaultReadOnly;
            return this;
        }

        public Builder setDefaultTransactionIsolation(int defaultTransactionIsolation) {
            this.defaultTransactionIsolation = defaultTransactionIsolation;
            return this;
        }

        public Builder setDisconnectionSqlCodes(String ... disconnectionSqlCodes) {
            this.disconnectionSqlCodes = disconnectionSqlCodes;
            return this;
        }

        public Builder setFastFailValidation(boolean fastFailValidation) {
            this.fastFailValidation = fastFailValidation;
            return this;
        }

        public Builder setMaxConnLifetimeMillis(long maxConnLifetimeMillis) {
            this.maxConnLifetimeMillis = maxConnLifetimeMillis;
            return this;
        }

        public Builder setMaxOpenPreparedStatements(int maxOpenPreparedStatements) {
            this.maxOpenPreparedStatements = maxOpenPreparedStatements;
            return this;
        }

        public Builder setPoolStatements(boolean poolStatements) {
            this.poolStatements = poolStatements;
            return this;
        }

        public Builder setRollbackOnReturn(boolean rollbackOnReturn) {
            this.rollbackOnReturn = rollbackOnReturn;
            return this;
        }

        public Builder setValidationQuery(String validationQuery) {
            this.validationQuery = validationQuery;
            return this;
        }

        public Builder setValidationQueryTimeoutSeconds(int validationQueryTimeoutSeconds) {
            this.validationQueryTimeoutSeconds = validationQueryTimeoutSeconds;
            return this;
        }
    }
}

