/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.parser;

import java.util.Arrays;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;

public abstract class LogEventParserTest {
    protected void assertLogEvent(LogEvent logEvent) {
        Assert.assertThat((Object)logEvent, (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)logEvent.getInstant().getEpochMillisecond(), (Matcher)CoreMatchers.equalTo((Object)1493121664118L));
        Assert.assertThat((Object)logEvent.getThreadName(), (Matcher)CoreMatchers.equalTo((Object)"main"));
        Assert.assertThat((Object)logEvent.getThreadId(), (Matcher)CoreMatchers.equalTo((Object)1L));
        Assert.assertThat((Object)logEvent.getThreadPriority(), (Matcher)CoreMatchers.equalTo((Object)5));
        Assert.assertThat((Object)logEvent.getLevel(), (Matcher)CoreMatchers.equalTo((Object)Level.INFO));
        Assert.assertThat((Object)logEvent.getLoggerName(), (Matcher)CoreMatchers.equalTo((Object)"HelloWorld"));
        Assert.assertThat((Object)logEvent.getMarker().getName(), (Matcher)CoreMatchers.equalTo((Object)"child"));
        Assert.assertThat((Object)logEvent.getMarker().getParents()[0].getName(), (Matcher)CoreMatchers.equalTo((Object)"parent"));
        Assert.assertThat((Object)logEvent.getMarker().getParents()[0].getParents()[0].getName(), (Matcher)CoreMatchers.equalTo((Object)"grandparent"));
        Assert.assertThat((Object)logEvent.getMessage().getFormattedMessage(), (Matcher)CoreMatchers.equalTo((Object)"Hello, world!"));
        Assert.assertThat((Object)logEvent.getThrown(), (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)logEvent.getThrownProxy().getMessage(), (Matcher)CoreMatchers.equalTo((Object)"error message"));
        Assert.assertThat((Object)logEvent.getThrownProxy().getName(), (Matcher)CoreMatchers.equalTo((Object)"java.lang.RuntimeException"));
        Assert.assertThat((Object)logEvent.getThrownProxy().getExtendedStackTrace()[0].getClassName(), (Matcher)CoreMatchers.equalTo((Object)"logtest.Main"));
        Assert.assertThat((Object)logEvent.getLoggerFqcn(), (Matcher)CoreMatchers.equalTo((Object)"org.apache.logging.log4j.spi.AbstractLogger"));
        Assert.assertThat((Object)logEvent.getContextStack().asList(), (Matcher)CoreMatchers.equalTo(Arrays.asList("one", "two")));
        Assert.assertThat((Object)((String)logEvent.getContextData().getValue("foo")), (Matcher)CoreMatchers.equalTo((Object)"FOO"));
        Assert.assertThat((Object)((String)logEvent.getContextData().getValue("bar")), (Matcher)CoreMatchers.equalTo((Object)"BAR"));
        Assert.assertThat((Object)logEvent.getSource().getClassName(), (Matcher)CoreMatchers.equalTo((Object)"logtest.Main"));
    }
}

