/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.core.appender.db.jdbc.AbstractConnectionSource;
import org.apache.logging.log4j.core.appender.db.jdbc.ConnectionSource;

public class JdbcH2TestHelper {
    static final String CONNECTION_STRING_MEM = "jdbc:h2:mem:Log4j";
    static final String CONNECTION_STRING_TMPDIR = "jdbc:h2:" + SystemUtils.JAVA_IO_TMPDIR + "/h2/test_log4j;TRACE_LEVEL_SYSTEM_OUT=0";
    static final String USER_NAME = "sa";
    static final String PASSWORD = "";
    public static ConnectionSource TEST_CONFIGURATION_SOURCE_MEM = new AbstractConnectionSource(){

        public Connection getConnection() throws SQLException {
            return JdbcH2TestHelper.getConnectionMem();
        }
    };
    public static ConnectionSource TEST_CONFIGURATION_SOURCE_TMPDIR = new AbstractConnectionSource(){

        public Connection getConnection() throws SQLException {
            return JdbcH2TestHelper.getConnectionTmpDir();
        }
    };

    public static Connection getConnectionMem() throws SQLException {
        return DriverManager.getConnection(CONNECTION_STRING_MEM, USER_NAME, PASSWORD);
    }

    public static Connection getConnectionTmpDir() throws SQLException {
        return DriverManager.getConnection(CONNECTION_STRING_TMPDIR, USER_NAME, PASSWORD);
    }
}

