/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.core.util.Cancellable;
import org.apache.logging.log4j.core.util.ShutdownCallbackRegistry;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.status.StatusLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class ShutdownCallbackRegistryTest {
    @BeforeAll
    public static void setUpClass() {
        System.setProperty("log4j2.is.webapp", "false");
        System.setProperty("log4j.shutdownCallbackRegistry", Registry.class.getName());
    }

    @AfterAll
    public static void afterClass() {
        System.clearProperty("log4j.shutdownCallbackRegistry");
        System.clearProperty("log4j2.is.webapp");
    }

    @Test
    @LoggerContextSource(value="ShutdownCallbackRegistryTest.xml")
    public void testShutdownCallbackRegistry(LoggerContext context) {
        Assertions.assertTrue((boolean)context.isStarted(), (String)"LoggerContext should be started");
        MatcherAssert.assertThat((Object)Registry.CALLBACKS, (Matcher)Matchers.hasSize((int)1));
        Registry.shutdown();
        Assertions.assertTrue((boolean)context.isStopped(), (String)"LoggerContext should be stopped");
        MatcherAssert.assertThat((Object)Registry.CALLBACKS, (Matcher)Matchers.hasSize((int)0));
        ContextSelector selector = ((Log4jContextFactory)LogManager.getFactory()).getSelector();
        MatcherAssert.assertThat((Object)selector.getLoggerContexts(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)context)));
    }

    public static class Registry
    implements ShutdownCallbackRegistry {
        private static final Logger LOGGER = StatusLogger.getLogger();
        private static final Collection<Cancellable> CALLBACKS = new ConcurrentLinkedQueue<Cancellable>();

        public Cancellable addShutdownCallback(final Runnable callback) {
            Cancellable cancellable = new Cancellable(){

                public void cancel() {
                    LOGGER.debug("Cancelled shutdown callback: {}", (Object)callback);
                    CALLBACKS.remove(this);
                }

                public void run() {
                    LOGGER.debug("Called shutdown callback: {}", (Object)callback);
                    callback.run();
                }
            };
            CALLBACKS.add(cancellable);
            return cancellable;
        }

        private static void shutdown() {
            for (Runnable runnable : CALLBACKS) {
                LOGGER.debug("Calling shutdown callback: {}", (Object)runnable);
                runnable.run();
            }
            CALLBACKS.clear();
        }
    }
}

