/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.async.RingBufferLogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.impl.MementoMessage;
import org.apache.logging.log4j.core.impl.MutableLogEvent;
import org.apache.logging.log4j.core.net.SmtpManager;
import org.apache.logging.log4j.core.util.ClockFactory;
import org.apache.logging.log4j.core.util.DummyNanoClock;
import org.apache.logging.log4j.core.util.NanoClock;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ReusableMessage;
import org.apache.logging.log4j.message.ReusableSimpleMessage;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SmtpManagerTest {
    SmtpManagerTest() {
    }

    @Test
    void testCreateManagerName() {
        String managerName = SmtpManager.createManagerName((String)"to", (String)"cc", null, (String)"from", null, (String)"LOG4J2-3107", (String)"proto", (String)"smtp.log4j.com", (int)4711, (String)"username", (boolean)false, (String)"filter");
        Assertions.assertEquals((Object)"SMTP:to:cc::from::LOG4J2-3107:proto:smtp.log4j.com:4711:username::filter", (Object)managerName);
    }

    private void testAdd(LogEvent event) {
        SmtpManager smtpManager = SmtpManager.getSmtpManager(null, (String)"to", (String)"cc", (String)"bcc", (String)"from", (String)"replyTo", (String)"subject", (String)"protocol", (String)"host", (int)0, (String)"username", (String)"password", (boolean)false, (String)"filterName", (int)10, null);
        smtpManager.removeAllBufferedEvents();
        smtpManager.add(event);
        LogEvent[] bufferedEvents = smtpManager.removeAllBufferedEvents();
        MatcherAssert.assertThat((String)"unexpected number of buffered events", (Object)bufferedEvents.length, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((String)"expected the immutable version of the event to be buffered", (Object)bufferedEvents[0].getMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(MementoMessage.class)));
    }

    @Test
    void testAdd_WhereLog4jLogEventWithReusableMessage() {
        Log4jLogEvent event = new Log4jLogEvent.Builder().setMessage((Message)this.getReusableMessage("test message")).build();
        this.testAdd((LogEvent)event);
    }

    @Test
    void testAdd_WhereMutableLogEvent() {
        MutableLogEvent event = new MutableLogEvent(new StringBuilder("test message"), null);
        this.testAdd((LogEvent)event);
    }

    @Test
    void testAdd_WhereRingBufferLogEvent() {
        RingBufferLogEvent event = new RingBufferLogEvent();
        event.setValues(null, null, null, null, null, (Message)this.getReusableMessage("test message"), null, null, null, 0L, null, 0, null, ClockFactory.getClock(), (NanoClock)new DummyNanoClock());
        this.testAdd((LogEvent)event);
    }

    private ReusableMessage getReusableMessage(String text) {
        ReusableSimpleMessage message = new ReusableSimpleMessage();
        message.set(text);
        return message;
    }
}

