/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.jmx;

import javax.management.ObjectName;
import org.apache.logging.log4j.core.jmx.Server;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ServerTest {
    @Test
    public void testEscapeQuotesButDoesNotEscapeEquals() throws Exception {
        String ctx = "WebAppClassLoader=1320771902@4eb9613e";
        String ctxName = Server.escape((String)"WebAppClassLoader=1320771902@4eb9613e");
        Assertions.assertEquals((Object)"\"WebAppClassLoader=1320771902@4eb9613e\"", (Object)ctxName);
        new ObjectName(String.format("org.apache.logging.log4j2:type=%s", ctxName));
    }

    @Test
    public void testEscapeQuotesButDoesNotEscapeComma() throws Exception {
        String ctx = "a,b,c";
        String ctxName = Server.escape((String)"a,b,c");
        Assertions.assertEquals((Object)"\"a,b,c\"", (Object)ctxName);
        new ObjectName(String.format("org.apache.logging.log4j2:type=%s", ctxName));
    }

    @Test
    public void testEscapeQuotesButDoesNotEscapeColon() throws Exception {
        String ctx = "a:b:c";
        String ctxName = Server.escape((String)"a:b:c");
        Assertions.assertEquals((Object)"\"a:b:c\"", (Object)ctxName);
        new ObjectName(String.format("org.apache.logging.log4j2:type=%s", ctxName));
    }

    @Test
    public void testEscapeQuotesAndEscapesQuestion() throws Exception {
        String ctx = "a?c";
        String ctxName = Server.escape((String)"a?c");
        Assertions.assertEquals((Object)"\"a\\?c\"", (Object)ctxName);
        new ObjectName(String.format("org.apache.logging.log4j2:type=%s", ctxName));
    }

    @Test
    public void testEscapeQuotesAndEscapesStar() throws Exception {
        String ctx = "a*c";
        String ctxName = Server.escape((String)"a*c");
        Assertions.assertEquals((Object)"\"a\\*c\"", (Object)ctxName);
        new ObjectName(String.format("org.apache.logging.log4j2:type=%s", ctxName));
    }

    @Test
    public void testEscapeQuotesAndEscapesBackslash() throws Exception {
        String ctx = "a\\c";
        String ctxName = Server.escape((String)"a\\c");
        Assertions.assertEquals((Object)"\"a\\\\c\"", (Object)ctxName);
        new ObjectName(String.format("org.apache.logging.log4j2:type=%s", ctxName));
    }

    @Test
    public void testEscapeQuotesAndEscapesQuote() throws Exception {
        String ctx = "a\"c";
        String ctxName = Server.escape((String)"a\"c");
        Assertions.assertEquals((Object)"\"a\\\"c\"", (Object)ctxName);
        new ObjectName(String.format("org.apache.logging.log4j2:type=%s", ctxName));
    }

    @Test
    public void testEscapeIgnoresSpaces() throws Exception {
        String ctx = "a c";
        String ctxName = Server.escape((String)"a c");
        Assertions.assertEquals((Object)"a c", (Object)ctxName);
        new ObjectName(String.format("org.apache.logging.log4j2:type=%s", ctxName));
    }

    @Test
    public void testEscapeEscapesLineFeed() throws Exception {
        String ctx = "a\rc";
        String ctxName = Server.escape((String)"a\rc");
        Assertions.assertEquals((Object)"ac", (Object)ctxName);
        new ObjectName(String.format("org.apache.logging.log4j2:type=%s", ctxName));
    }

    @Test
    public void testEscapeEscapesCarriageReturn() throws Exception {
        String ctx = "a\nc";
        String ctxName = Server.escape((String)"a\nc");
        Assertions.assertEquals((Object)"\"a\\nc\"", (Object)ctxName);
        new ObjectName(String.format("org.apache.logging.log4j2:type=%s", ctxName));
    }
}

