/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.async.ThreadNameCachingStrategy;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={AsyncLoggers.class})
public class AsyncLoggerThreadNameStrategyTest {
    @After
    public void after() {
        System.clearProperty("AsyncLogger.ThreadNameStrategy");
    }

    @Before
    public void before() {
        System.clearProperty("AsyncLogger.ThreadNameStrategy");
    }

    @Test
    public void testDefaultIfNotConfigured() throws Exception {
        ThreadNameCachingStrategy tns = ThreadNameCachingStrategy.create();
        Assert.assertSame((Object)ThreadNameCachingStrategy.DEFAULT_STRATEGY, (Object)tns);
    }

    @Test
    public void testDefaultIfInvalidConfig() throws Exception {
        System.setProperty("AsyncLogger.ThreadNameStrategy", "\\%%InValid ");
        ThreadNameCachingStrategy tns = ThreadNameCachingStrategy.create();
        Assert.assertSame((Object)ThreadNameCachingStrategy.DEFAULT_STRATEGY, (Object)tns);
    }

    @Test
    public void testUseCachedThreadNameIfConfigured() throws Exception {
        System.setProperty("AsyncLogger.ThreadNameStrategy", "CACHED");
        ThreadNameCachingStrategy tns = ThreadNameCachingStrategy.create();
        Assert.assertSame((Object)ThreadNameCachingStrategy.CACHED, (Object)tns);
    }

    @Test
    public void testUseUncachedThreadNameIfConfigured() throws Exception {
        System.setProperty("AsyncLogger.ThreadNameStrategy", "UNCACHED");
        ThreadNameCachingStrategy tns = ThreadNameCachingStrategy.create();
        Assert.assertSame((Object)ThreadNameCachingStrategy.UNCACHED, (Object)tns);
    }

    @Test
    public void testUncachedThreadNameStrategyReturnsCurrentThreadName() throws Exception {
        String name1 = "MODIFIED-THREADNAME1";
        Thread.currentThread().setName("MODIFIED-THREADNAME1");
        Assert.assertEquals((Object)"MODIFIED-THREADNAME1", (Object)ThreadNameCachingStrategy.UNCACHED.getThreadName());
        String name2 = "OTHER-THREADNAME2";
        Thread.currentThread().setName("OTHER-THREADNAME2");
        Assert.assertEquals((Object)"OTHER-THREADNAME2", (Object)ThreadNameCachingStrategy.UNCACHED.getThreadName());
    }

    @Test
    public void testCachedThreadNameStrategyReturnsCachedThreadName() throws Exception {
        String original = "Original-ThreadName";
        Thread.currentThread().setName("Original-ThreadName");
        Assert.assertEquals((Object)"Original-ThreadName", (Object)ThreadNameCachingStrategy.CACHED.getThreadName());
        String name2 = "OTHER-THREADNAME2";
        Thread.currentThread().setName("OTHER-THREADNAME2");
        Assert.assertEquals((Object)"Original-ThreadName", (Object)ThreadNameCachingStrategy.CACHED.getThreadName());
    }
}

