/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.mom;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.MapMessage;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.categories.Appenders;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.mom.JmsAppender;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.junit.JndiRule;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.message.StringMapMessage;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mockito;

@Category(value={Appenders.Jms.class})
public class JmsAppenderTest {
    private static final String CONNECTION_FACTORY_NAME = "jms/connectionFactory";
    private static final String QUEUE_FACTORY_NAME = "jms/queues";
    private static final String TOPIC_FACTORY_NAME = "jms/topics";
    private static final String DESTINATION_NAME = "jms/destination";
    private static final String DESTINATION_NAME_ML = "jms/destination-ml";
    private static final String QUEUE_NAME = "jms/queue";
    private static final String TOPIC_NAME = "jms/topic";
    private static final String LOG_MESSAGE = "Hello, world!";
    private final ConnectionFactory connectionFactory = (ConnectionFactory)Mockito.mock(ConnectionFactory.class);
    private final Connection connection = (Connection)Mockito.mock(Connection.class);
    private final Session session = (Session)Mockito.mock(Session.class);
    private final Destination destination = (Destination)Mockito.mock(Destination.class);
    private final Destination destinationMl = (Destination)Mockito.mock(Destination.class);
    private final MessageProducer messageProducer = (MessageProducer)Mockito.mock(MessageProducer.class);
    private final MessageProducer messageProducerMl = (MessageProducer)Mockito.mock(MessageProducer.class);
    private final TextMessage textMessage = (TextMessage)Mockito.mock(TextMessage.class);
    private final ObjectMessage objectMessage = (ObjectMessage)Mockito.mock(ObjectMessage.class);
    private final MapMessage mapMessage = (MapMessage)Mockito.mock(MapMessage.class);
    private final JndiRule jndiRule = new JndiRule(this.createBindings());
    private final LoggerContextRule ctx = new LoggerContextRule("JmsAppenderTest.xml");
    @Rule
    public RuleChain rules = RuleChain.outerRule((TestRule)this.jndiRule).around((TestRule)this.ctx);

    @BeforeClass
    public static void afterClass() throws Exception {
        System.clearProperty("log4j2.enableJndiJms");
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        System.setProperty("log4j2.enableJndiJms", "true");
    }

    public JmsAppenderTest() throws Exception {
        BDDMockito.given((Object)this.connectionFactory.createConnection()).willReturn((Object)this.connection);
        BDDMockito.given((Object)this.connectionFactory.createConnection(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).willThrow(IllegalArgumentException.class);
        BDDMockito.given((Object)this.connection.createSession(ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((int)1))).willReturn((Object)this.session);
        BDDMockito.given((Object)this.session.createProducer((Destination)ArgumentMatchers.eq((Object)this.destination))).willReturn((Object)this.messageProducer);
        BDDMockito.given((Object)this.session.createProducer((Destination)ArgumentMatchers.eq((Object)this.destinationMl))).willReturn((Object)this.messageProducerMl);
        BDDMockito.given((Object)this.session.createTextMessage(ArgumentMatchers.anyString())).willReturn((Object)this.textMessage);
        BDDMockito.given((Object)this.session.createObjectMessage((Serializable)ArgumentMatchers.isA(Serializable.class))).willReturn((Object)this.objectMessage);
        BDDMockito.given((Object)this.session.createMapMessage()).willReturn((Object)this.mapMessage);
    }

    private Map<String, Object> createBindings() {
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        map.put(CONNECTION_FACTORY_NAME, this.connectionFactory);
        map.put(DESTINATION_NAME, this.destination);
        map.put(DESTINATION_NAME_ML, this.destinationMl);
        map.put(QUEUE_FACTORY_NAME, this.connectionFactory);
        map.put(QUEUE_NAME, this.destination);
        map.put(TOPIC_FACTORY_NAME, this.connectionFactory);
        map.put(TOPIC_NAME, this.destination);
        return map;
    }

    private Log4jLogEvent createLogEvent() {
        return this.createLogEvent((Message)new SimpleMessage(LOG_MESSAGE));
    }

    private Log4jLogEvent createLogEvent(Message message) {
        return Log4jLogEvent.newBuilder().setLoggerName(JmsAppenderTest.class.getName()).setLoggerFqcn(JmsAppenderTest.class.getName()).setLevel(Level.INFO).setMessage(message).build();
    }

    private Log4jLogEvent createMapMessageLogEvent() {
        StringMapMessage mapMessage = new StringMapMessage();
        return this.createLogEvent((Message)mapMessage.with("testMesage", LOG_MESSAGE));
    }

    @Before
    public void setUp() throws Exception {
        ((Connection)BDDMockito.then((Object)this.connection).should(Mockito.times((int)4))).start();
    }

    @Test
    public void testAppendToQueue() throws Exception {
        JmsAppender appender = (JmsAppender)this.ctx.getRequiredAppender("JmsAppender");
        Log4jLogEvent event = this.createLogEvent();
        appender.append((LogEvent)event);
        ((Session)BDDMockito.then((Object)this.session).should()).createTextMessage((String)ArgumentMatchers.eq((Object)LOG_MESSAGE));
        ((TextMessage)BDDMockito.then((Object)this.textMessage).should()).setJMSTimestamp(ArgumentMatchers.anyLong());
        ((MessageProducer)BDDMockito.then((Object)this.messageProducer).should()).send((javax.jms.Message)this.textMessage);
        appender.stop();
        ((Session)BDDMockito.then((Object)this.session).should()).close();
        ((Connection)BDDMockito.then((Object)this.connection).should()).close();
    }

    @Test
    public void testAppendToQueueWithMessageLayout() throws Exception {
        JmsAppender appender = (JmsAppender)this.ctx.getRequiredAppender("JmsAppender-MessageLayout");
        Log4jLogEvent event = this.createMapMessageLogEvent();
        appender.append((LogEvent)event);
        ((Session)BDDMockito.then((Object)this.session).should()).createMapMessage();
        ((MapMessage)BDDMockito.then((Object)this.mapMessage).should()).setJMSTimestamp(ArgumentMatchers.anyLong());
        ((MessageProducer)BDDMockito.then((Object)this.messageProducerMl).should()).send((javax.jms.Message)this.mapMessage);
        appender.stop();
        ((Session)BDDMockito.then((Object)this.session).should()).close();
        ((Connection)BDDMockito.then((Object)this.connection).should()).close();
    }

    @Test
    public void testJmsQueueAppenderCompatibility() throws Exception {
        JmsAppender appender = (JmsAppender)this.ctx.getRequiredAppender("JmsQueueAppender");
        Log4jLogEvent expected = this.createLogEvent();
        appender.append((LogEvent)expected);
        ((Session)BDDMockito.then((Object)this.session).should()).createObjectMessage((Serializable)ArgumentMatchers.eq((Object)expected));
        ((ObjectMessage)BDDMockito.then((Object)this.objectMessage).should()).setJMSTimestamp(ArgumentMatchers.anyLong());
        ((MessageProducer)BDDMockito.then((Object)this.messageProducer).should()).send((javax.jms.Message)this.objectMessage);
        appender.stop();
        ((Session)BDDMockito.then((Object)this.session).should()).close();
        ((Connection)BDDMockito.then((Object)this.connection).should()).close();
    }

    @Test
    public void testJmsTopicAppenderCompatibility() throws Exception {
        JmsAppender appender = (JmsAppender)this.ctx.getRequiredAppender("JmsTopicAppender");
        Log4jLogEvent expected = this.createLogEvent();
        appender.append((LogEvent)expected);
        ((Session)BDDMockito.then((Object)this.session).should()).createObjectMessage((Serializable)ArgumentMatchers.eq((Object)expected));
        ((ObjectMessage)BDDMockito.then((Object)this.objectMessage).should()).setJMSTimestamp(ArgumentMatchers.anyLong());
        ((MessageProducer)BDDMockito.then((Object)this.messageProducer).should()).send((javax.jms.Message)this.objectMessage);
        appender.stop();
        ((Session)BDDMockito.then((Object)this.session).should()).close();
        ((Connection)BDDMockito.then((Object)this.connection).should()).close();
    }
}

