/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.logging.log4j2;

import liquibase.logging.core.AbstractLogger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.spi.ExtendedLogger;

public class Log4j2Logger
extends AbstractLogger {
    private static final String FQCN = Log4j2Logger.class.getName();
    private ExtendedLogger logger;

    public void debug(String message) {
        this.logger.logIfEnabled(FQCN, Level.DEBUG, null, this.buildMessage(message));
    }

    public void debug(String message, Throwable e) {
        this.logger.logIfEnabled(FQCN, Level.DEBUG, null, this.buildMessage(message), e);
    }

    public int getPriority() {
        return 5;
    }

    public void info(String message) {
        this.logger.logIfEnabled(FQCN, Level.INFO, null, this.buildMessage(message));
    }

    public void info(String message, Throwable e) {
        this.logger.logIfEnabled(FQCN, Level.INFO, null, this.buildMessage(message), e);
    }

    public void setLogLevel(String logLevel, String logFile) {
        this.setLogLevel(logLevel);
    }

    public void setName(String name) {
        this.logger = LogManager.getContext((boolean)false).getLogger(name);
    }

    public void severe(String message) {
        this.logger.logIfEnabled(FQCN, Level.ERROR, null, this.buildMessage(message));
    }

    public void severe(String message, Throwable e) {
        this.logger.logIfEnabled(FQCN, Level.ERROR, null, this.buildMessage(message), e);
    }

    public void warning(String message) {
        this.logger.logIfEnabled(FQCN, Level.WARN, null, this.buildMessage(message));
    }

    public void warning(String message, Throwable e) {
        this.logger.logIfEnabled(FQCN, Level.WARN, null, this.buildMessage(message), e);
    }
}

