/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.categories.Layouts;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.BasicConfigurationFactory;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.jackson.Log4jYamlObjectMapper;
import org.apache.logging.log4j.core.layout.AbstractJacksonLayout;
import org.apache.logging.log4j.core.layout.LogEventFixtures;
import org.apache.logging.log4j.core.layout.YamlLayout;
import org.apache.logging.log4j.core.lookup.JavaLookup;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.apache.logging.log4j.util.Strings;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Layouts.Yaml.class})
public class YamlLayoutTest {
    static ConfigurationFactory cf = new BasicConfigurationFactory();
    LoggerContext ctx = LoggerContext.getContext();
    Logger rootLogger = this.ctx.getRootLogger();

    @AfterClass
    public static void cleanupClass() {
        ConfigurationFactory.removeConfigurationFactory((ConfigurationFactory)cf);
        ThreadContext.clearAll();
    }

    @BeforeClass
    public static void setupClass() {
        ThreadContext.clearAll();
        ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)cf);
        LoggerContext ctx = LoggerContext.getContext();
        ctx.reconfigure();
    }

    private void checkAt(String expected, int lineIndex, List<String> list) {
        String trimedLine = list.get(lineIndex).trim();
        Assert.assertTrue((String)("Incorrect line index " + lineIndex + ": " + Strings.dquote((String)trimedLine)), (boolean)trimedLine.equals(expected));
    }

    private void checkContains(String expected, List<String> list) {
        for (String string : list) {
            String trimedLine = string.trim();
            if (!trimedLine.equals(expected)) continue;
            return;
        }
        Assert.fail((String)("Cannot find " + expected + " in " + list));
    }

    private void checkMapEntry(String key, String value, boolean compact, String str) {
        String expected = String.format("%s: \"%s\"", key, value);
        Assert.assertTrue((String)("Cannot find " + expected + " in " + str), (boolean)str.contains(expected));
    }

    private void checkProperty(String key, String value, boolean compact, String str, boolean isValue) {
        String propSep = this.toPropertySeparator(compact, isValue);
        String expected = String.format("%s%s\"%s\"", key, propSep, value);
        Assert.assertTrue((String)("Cannot find " + expected + " in " + str), (boolean)str.contains(expected));
    }

    private void checkPropertyName(String name, boolean compact, String str, boolean isValue) {
        String propSep = this.toPropertySeparator(compact, isValue);
        Assert.assertTrue((String)str, (boolean)str.contains(name + propSep));
    }

    private void checkPropertyNameAbsent(String name, boolean compact, String str, boolean isValue) {
        String propSep = this.toPropertySeparator(compact, isValue);
        Assert.assertFalse((String)str, (boolean)str.contains(name + propSep));
    }

    private void testAllFeatures(boolean includeSource, boolean compact, boolean eventEol, boolean includeContext, boolean contextMapAslist, boolean includeStacktrace) throws Exception {
        Log4jLogEvent expected = LogEventFixtures.createLogEvent();
        YamlLayout layout = ((YamlLayout.Builder)((YamlLayout.Builder)((YamlLayout.Builder)((YamlLayout.Builder)YamlLayout.newBuilder().setLocationInfo(includeSource)).setProperties(includeContext)).setIncludeStacktrace(includeStacktrace)).setCharset(StandardCharsets.UTF_8)).build();
        String str = layout.toSerializable((LogEvent)expected);
        Assert.assertEquals((String)str, (Object)(!compact || eventEol ? 1 : 0), (Object)str.contains("\n"));
        Assert.assertEquals((String)str, (Object)includeSource, (Object)str.contains("source"));
        Assert.assertEquals((String)str, (Object)includeContext, (Object)str.contains("contextMap"));
        Log4jLogEvent actual = (Log4jLogEvent)new Log4jYamlObjectMapper(contextMapAslist, includeStacktrace, false).readValue(str, Log4jLogEvent.class);
        LogEventFixtures.assertEqualLogEvents((LogEvent)expected, (LogEvent)actual, includeSource, includeContext, includeStacktrace);
        if (includeContext) {
            this.checkMapEntry("MDC.A", "A_Value", compact, str);
            this.checkMapEntry("MDC.B", "B_Value", compact, str);
        }
        Assert.assertNull((Object)actual.getThrown());
        this.checkPropertyName("instant", compact, str, false);
        this.checkPropertyName("thread", compact, str, true);
        this.checkPropertyName("level", compact, str, true);
        this.checkPropertyName("loggerName", compact, str, true);
        this.checkPropertyName("marker", compact, str, false);
        this.checkPropertyName("name", compact, str, true);
        this.checkPropertyName("parents", compact, str, false);
        this.checkPropertyName("message", compact, str, true);
        this.checkPropertyName("thrown", compact, str, false);
        this.checkPropertyName("cause", compact, str, false);
        this.checkPropertyName("commonElementCount", compact, str, true);
        this.checkPropertyName("localizedMessage", compact, str, true);
        if (includeStacktrace) {
            this.checkPropertyName("extendedStackTrace", compact, str, false);
            this.checkPropertyName("class", compact, str, true);
            this.checkPropertyName("method", compact, str, true);
            this.checkPropertyName("file", compact, str, true);
            this.checkPropertyName("line", compact, str, true);
            this.checkPropertyName("exact", compact, str, true);
            this.checkPropertyName("location", compact, str, true);
            this.checkPropertyName("version", compact, str, true);
        } else {
            this.checkPropertyNameAbsent("extendedStackTrace", compact, str, false);
        }
        this.checkPropertyName("suppressed", compact, str, false);
        this.checkPropertyName("loggerFqcn", compact, str, true);
        this.checkPropertyName("endOfBatch", compact, str, true);
        if (includeContext) {
            this.checkPropertyName("contextMap", compact, str, false);
        } else {
            this.checkPropertyNameAbsent("contextMap", compact, str, false);
        }
        this.checkPropertyName("contextStack", compact, str, false);
        if (includeSource) {
            this.checkPropertyName("source", compact, str, false);
        } else {
            this.checkPropertyNameAbsent("source", compact, str, false);
        }
        this.checkProperty("loggerFqcn", "f.q.c.n", compact, str, true);
        this.checkProperty("loggerName", "a.B", compact, str, true);
    }

    @Test
    public void testContentType() {
        AbstractJacksonLayout layout = YamlLayout.createDefaultLayout();
        Assert.assertEquals((Object)"application/yaml; charset=UTF-8", (Object)layout.getContentType());
    }

    @Test
    public void testDefaultCharset() {
        AbstractJacksonLayout layout = YamlLayout.createDefaultLayout();
        Assert.assertEquals((Object)StandardCharsets.UTF_8, (Object)layout.getCharset());
    }

    @Test
    public void testEscapeLayout() throws Exception {
        Map appenders = this.rootLogger.getAppenders();
        for (Appender appender : appenders.values()) {
            this.rootLogger.removeAppender(appender);
        }
        Configuration configuration = this.rootLogger.getContext().getConfiguration();
        YamlLayout layout = ((YamlLayout.Builder)((YamlLayout.Builder)((YamlLayout.Builder)((YamlLayout.Builder)YamlLayout.newBuilder().setLocationInfo(true)).setProperties(true)).setIncludeStacktrace(true)).setConfiguration(configuration)).build();
        ListAppender appender = new ListAppender("List", null, (Layout<? extends Serializable>)layout, true, false);
        appender.start();
        this.rootLogger.addAppender((Appender)appender);
        this.rootLogger.setLevel(Level.DEBUG);
        this.rootLogger.debug("Here is a quote ' and then a double quote \"");
        appender.stop();
        List<String> list = appender.getMessages();
        this.checkAt("---", 0, list);
        this.checkContains("level: \"DEBUG\"", list);
        this.checkContains("message: \"Here is a quote ' and then a double quote \\\"\"", list);
        this.checkContains("loggerFqcn: \"" + AbstractLogger.class.getName() + "\"", list);
        for (Appender app : appenders.values()) {
            this.rootLogger.addAppender(app);
        }
    }

    @Test
    public void testLayout() throws Exception {
        Map appenders = this.rootLogger.getAppenders();
        for (Appender appender : appenders.values()) {
            this.rootLogger.removeAppender(appender);
        }
        Configuration configuration = this.rootLogger.getContext().getConfiguration();
        AbstractJacksonLayout layout = YamlLayout.createLayout((Configuration)configuration, (boolean)true, (boolean)true, (String)"[[", (String)"]]", null, (boolean)true);
        ListAppender appender = new ListAppender("List", null, (Layout<? extends Serializable>)layout, true, false);
        appender.start();
        this.rootLogger.addAppender((Appender)appender);
        this.rootLogger.setLevel(Level.DEBUG);
        this.rootLogger.debug("starting mdc pattern test");
        this.rootLogger.debug("empty mdc");
        ThreadContext.put((String)"key1", (String)"value1");
        ThreadContext.put((String)"key2", (String)"value2");
        this.rootLogger.debug("filled mdc");
        ThreadContext.remove((String)"key1");
        ThreadContext.remove((String)"key2");
        this.rootLogger.error("finished mdc pattern test", (Throwable)new NullPointerException("test"));
        appender.stop();
        List<String> list = appender.getMessages();
        this.checkAt("---", 0, list);
        this.checkContains("loggerFqcn: \"" + AbstractLogger.class.getName() + "\"", list);
        this.checkContains("level: \"DEBUG\"", list);
        this.checkContains("message: \"starting mdc pattern test\"", list);
        for (Appender app : appenders.values()) {
            this.rootLogger.addAppender(app);
        }
    }

    @Test
    public void testLayoutLoggerName() throws Exception {
        YamlLayout layout = ((YamlLayout.Builder)((YamlLayout.Builder)((YamlLayout.Builder)((YamlLayout.Builder)YamlLayout.newBuilder().setLocationInfo(false)).setProperties(false)).setIncludeStacktrace(true)).setCharset(StandardCharsets.UTF_8)).build();
        Log4jLogEvent expected = Log4jLogEvent.newBuilder().setLoggerName("a.B").setLoggerFqcn("f.q.c.n").setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("M")).setThreadName("threadName").setTimeMillis(1L).build();
        String str = layout.toSerializable((LogEvent)expected);
        Assert.assertTrue((String)str, (boolean)str.contains("loggerName: \"a.B\""));
        Log4jLogEvent actual = (Log4jLogEvent)new Log4jYamlObjectMapper(false, true, false).readValue(str, Log4jLogEvent.class);
        Assert.assertEquals((Object)expected.getLoggerName(), (Object)actual.getLoggerName());
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAdditionalFields() throws Exception {
        YamlLayout layout = ((YamlLayout.Builder)((YamlLayout.Builder)((YamlLayout.Builder)((YamlLayout.Builder)((YamlLayout.Builder)((YamlLayout.Builder)YamlLayout.newBuilder().setLocationInfo(false)).setProperties(false)).setIncludeStacktrace(false)).setAdditionalFields(new KeyValuePair[]{new KeyValuePair("KEY1", "VALUE1"), new KeyValuePair("KEY2", "${java:runtime}")})).setCharset(StandardCharsets.UTF_8)).setConfiguration(this.ctx.getConfiguration())).build();
        String str = layout.toSerializable((LogEvent)LogEventFixtures.createLogEvent());
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        JsonNode node = mapper.readTree(str);
        Assert.assertThat((Object)this.getJSONChildNodeValueAsText(node, "KEY1"), (Matcher)CoreMatchers.equalTo((Object)"VALUE1"));
        Assert.assertThat((Object)this.getJSONChildNodeValueAsText(node, "KEY2"), (Matcher)CoreMatchers.equalTo((Object)new JavaLookup().getRuntime()));
    }

    private String getJSONChildNodeValueAsText(JsonNode parentNode, String key) {
        JsonNode childNode = parentNode.get(key);
        if (childNode != null) {
            return childNode.asText();
        }
        return "";
    }

    @Test
    public void testLocationOffCompactOffMdcOff() throws Exception {
        this.testAllFeatures(false, false, false, false, false, true);
    }

    @Test
    public void testLocationOnCompactOffEventEolOffMdcOn() throws Exception {
        this.testAllFeatures(true, false, false, true, false, true);
    }

    @Test
    public void testExcludeStacktrace() throws Exception {
        this.testAllFeatures(false, false, false, false, false, false);
    }

    @Test
    public void testStacktraceAsString() throws Exception {
        String str = this.prepareYAMLForStacktraceTests(true);
        Assert.assertTrue((String)str, (boolean)str.contains("extendedStackTrace: \"java.lang.NullPointerException"));
    }

    @Test
    public void testStacktraceAsNonString() throws Exception {
        String str = this.prepareYAMLForStacktraceTests(false);
        Assert.assertTrue((String)str, (boolean)str.contains("extendedStackTrace:\n    - "));
    }

    private String prepareYAMLForStacktraceTests(boolean stacktraceAsString) {
        Log4jLogEvent expected = LogEventFixtures.createLogEvent();
        YamlLayout layout = ((YamlLayout.Builder)((YamlLayout.Builder)YamlLayout.newBuilder().setIncludeStacktrace(true)).setStacktraceAsString(stacktraceAsString)).build();
        return layout.toSerializable((LogEvent)expected);
    }

    @Test
    public void testIncludeNullDelimiterTrue() throws Exception {
        YamlLayout layout = ((YamlLayout.Builder)YamlLayout.newBuilder().setIncludeNullDelimiter(true)).build();
        String str = layout.toSerializable((LogEvent)LogEventFixtures.createLogEvent());
        Assert.assertTrue((boolean)str.endsWith("\u0000"));
    }

    @Test
    public void testIncludeNullDelimiterFalse() throws Exception {
        YamlLayout layout = ((YamlLayout.Builder)YamlLayout.newBuilder().setIncludeNullDelimiter(false)).build();
        String str = layout.toSerializable((LogEvent)LogEventFixtures.createLogEvent());
        Assert.assertFalse((boolean)str.endsWith("\u0000"));
    }

    private String toPropertySeparator(boolean compact, boolean value) {
        return value ? ": " : ":";
    }
}

