/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import com.lmax.disruptor.ExceptionHandler;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.CoreLoggerContexts;
import org.apache.logging.log4j.core.async.AsyncLoggerContextSelector;
import org.apache.logging.log4j.core.async.RingBufferLogEvent;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ReusableSimpleMessage;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.junit.experimental.categories.Category;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

@Category(value={AsyncLoggers.class})
class AsyncLoggerEventTranslationExceptionTest {
    AsyncLoggerEventTranslationExceptionTest() {
    }

    @BeforeAll
    public static void beforeAll() {
        System.setProperty("Log4jContextSelector", AsyncLoggerContextSelector.class.getName());
        System.setProperty("AsyncLogger.ExceptionHandler", TestExceptionHandler.class.getName());
    }

    @AfterAll
    public static void afterAll() {
        System.clearProperty("Log4jContextSelector");
        System.clearProperty("AsyncLogger.ExceptionHandler");
    }

    @Test
    void testEventTranslationExceptionDoesNotCauseAsyncEventException() {
        Logger log = LogManager.getLogger((String)"com.foo.Bar");
        Assertions.assertTrue((boolean)TestExceptionHandler.INSTANTIATED, (String)"TestExceptionHandler was not configured properly");
        ExceptionThrowingMessage exceptionThrowingMessage = new ExceptionThrowingMessage();
        Assertions.assertThrows(TestMessageException.class, () -> AsyncLoggerEventTranslationExceptionTest.lambda$testEventTranslationExceptionDoesNotCauseAsyncEventException$0(log, (Message)exceptionThrowingMessage));
        CoreLoggerContexts.stopLoggerContext();
        Assertions.assertFalse((boolean)TestExceptionHandler.EVENT_EXCEPTION_ENCOUNTERED, (String)"ExceptionHandler encountered an event exception");
    }

    private static /* synthetic */ void lambda$testEventTranslationExceptionDoesNotCauseAsyncEventException$0(Logger log, Message exceptionThrowingMessage) throws Throwable {
        ((AbstractLogger)log).logMessage("com.foo.Bar", Level.INFO, null, exceptionThrowingMessage, null);
    }

    private static final class ExceptionThrowingMessage
    extends ReusableSimpleMessage {
        private ExceptionThrowingMessage() {
        }

        public String getFormattedMessage() {
            throw new TestMessageException();
        }

        public String getFormat() {
            throw new TestMessageException();
        }

        public Object[] getParameters() {
            throw new TestMessageException();
        }

        public void formatTo(StringBuilder buffer) {
            throw new TestMessageException();
        }

        public Object[] swapParameters(Object[] emptyReplacement) {
            throw new TestMessageException();
        }

        public short getParameterCount() {
            throw new TestMessageException();
        }
    }

    private static class TestMessageException
    extends RuntimeException {
        private TestMessageException() {
        }
    }

    public static final class TestExceptionHandler
    implements ExceptionHandler<RingBufferLogEvent> {
        private static boolean INSTANTIATED = false;
        private static boolean EVENT_EXCEPTION_ENCOUNTERED = false;

        public TestExceptionHandler() {
            INSTANTIATED = true;
        }

        public void handleEventException(Throwable error, long sequence, RingBufferLogEvent event) {
            EVENT_EXCEPTION_ENCOUNTERED = true;
        }

        public void handleOnStartException(Throwable error) {
            Assertions.fail((String)("Unexpected start exception: " + error.getMessage()));
        }

        public void handleOnShutdownException(Throwable error) {
            Assertions.fail((String)("Unexpected shutdown exception: " + error.getMessage()));
        }
    }
}

